/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.gfx;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.game.gfx.GFX;

public class CompositeCardGFX
extends GFX {
    private final CardIndex cardIndex;
    private final Function<CardIndex, GFX>[] handlers;
    private final List<GFX> list = new ArrayList<GFX>();

    @SafeVarargs
    public CompositeCardGFX(CardIndex cardIndex, Function<CardIndex, GFX> ... handlers) {
        this.cardIndex = cardIndex;
        this.handlers = handlers;
    }

    @Override
    protected void onAttached() {
        for (Function<CardIndex, GFX> function : this.handlers) {
            GFX gfx = function.apply(this.cardIndex);
            this.list.add(gfx);
            gfx.attach();
        }
    }

    @Override
    protected void onDetached() {
        for (GFX gfx : this.list) {
            gfx.detach();
        }
        this.list.clear();
    }
}

