/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.gfx;

import java.util.ArrayList;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.shape.CullFace;
import javafx.util.Duration;
import open.batoru.ImageCache;
import open.batoru.UtilRandom;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldData;
import open.batoru.game.Zone;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.Plane;
import open.batoru.game._3d.Vector3D;
import open.batoru.game.animations.tracker.TrackableAnimation;
import open.batoru.game.gfx.GFX;
import open.batoru.ui.UI;

public class GFXZoneSpriteFall
extends GFX {
    private final Game.GamePlayerRole rolePlayer;
    private final Group3D node = new Group3D();
    private final double fallHeight;
    private final double fallDuration;
    private final Zone zone;
    private final List<TrackableAnimation> animations = new ArrayList<TrackableAnimation>();

    public GFXZoneSpriteFall(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, String textureName, int count, int width, int height, int fallHeight, int fallDuration, int[] colorRGB) {
        this.zone = FieldData.getZoneByLocation(rolePlayer, location);
        if (this.zone == null) {
            throw new IllegalArgumentException();
        }
        this.fallHeight = fallHeight;
        this.fallDuration = fallDuration;
        Image texture = ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath(textureName));
        for (int i = 0; i < count; ++i) {
            Plane fallNode = new Plane(width, height, texture);
            fallNode.getMaterial().setDiffuseColor(Color.rgb((int)colorRGB[0], (int)colorRGB[1], (int)colorRGB[2]));
            fallNode.getRender().setCullFace(CullFace.NONE);
            fallNode.setVisible(false);
            AnimationSpriteFall aniFall = new AnimationSpriteFall(fallNode);
            aniFall.setDelay(Duration.millis((double)UtilRandom.get(0, fallDuration)));
            aniFall.play();
            this.animations.add(aniFall);
            this.node.getChildren().add((Object)fallNode);
        }
        this.node.setTranslate(this.zone.getNode());
        this.node.setMouseTransparent(true);
        this.rolePlayer = rolePlayer;
    }

    @Override
    protected void onAttached() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getChildren().addLast((Object)this.node);
    }

    @Override
    protected void onDetached() {
        for (TrackableAnimation ani : this.animations) {
            ani.stop();
        }
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getChildren().remove((Object)this.node);
    }

    public class AnimationSpriteFall
    extends TrackableAnimation {
        private final Group3D fallNode;
        private Vector3D startPos;
        private Vector3D rot;

        public AnimationSpriteFall(Group3D fallNode) {
            this.setInterpolator(Interpolator.EASE_OUT);
            this.setCycleDuration(Duration.millis((double)GFXZoneSpriteFall.this.fallDuration));
            this.fallNode = fallNode;
            this.setOnAnimationFinished(() -> {
                this.setDelay(Duration.ZERO);
                this.play();
            });
        }

        @Override
        public void play() {
            this.fallNode.setTranslate(UtilRandom.get(-GFXZoneSpriteFall.this.zone.getWidth() / 2, GFXZoneSpriteFall.this.zone.getWidth() / 2), UtilRandom.get(-GFXZoneSpriteFall.this.zone.getHeight() / 2, GFXZoneSpriteFall.this.zone.getHeight() / 2), -GFXZoneSpriteFall.this.fallHeight);
            this.startPos = new Vector3D(this.fallNode, Vector3D.VectorType.ORIGIN);
            this.rot = new Vector3D(UtilRandom.get(-360, 360), UtilRandom.get(-360, 360), UtilRandom.get(-360, 360));
            super.play();
        }

        public void interpolate(double frac) {
            this.fallNode.setVisible(true);
            this.fallNode.setTransZ(this.startPos.getZ() - this.startPos.getZ() * frac);
            this.fallNode.setRotate(this.rot, frac);
        }
    }
}

