/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.gfx;

import java.util.function.Function;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldData;
import open.batoru.game.Zone;
import open.batoru.game.gfx.GFX;

public class GFXZoneTopCardDecorator
extends GFX {
    private final Zone zone;
    private final Function<CardIndex, GFX> handlerSample;
    private Zone.OnCardMovedHandler handler;
    private GFX gfx;

    public GFXZoneTopCardDecorator(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, Function<CardIndex, GFX> handlerSample) {
        Zone zone = FieldData.getZoneByLocation(rolePlayer, location);
        if (zone == null) {
            throw new IllegalArgumentException();
        }
        this.zone = zone;
        this.handlerSample = handlerSample;
    }

    @Override
    protected void onAttached() {
        this.updateNode();
        this.handler = (card3D, rearrangeType) -> this.updateNode();
        this.zone.setOnCardMoved(this.handler);
    }

    private void updateNode() {
        if (this.zone.getTotalCards() != 0) {
            if (this.gfx != null) {
                this.gfx.detach();
            }
            this.gfx = this.handlerSample.apply(this.zone.getTopCard().getCardIndex());
            this.gfx.attach();
        } else {
            this.gfx.detach();
            this.gfx = null;
        }
    }

    @Override
    protected void onDetached() {
        this.gfx.detach();
        this.gfx = null;
        this.zone.removeCardMovedHandler(this.handler);
        this.handler = null;
    }
}

