/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.gfx;

import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldData;
import open.batoru.game.FieldStackZone;
import open.batoru.game.Zone;
import open.batoru.game._3d.ZoneUnderTypeIndicator;
import open.batoru.game.gfx.GFX;

public class GFXZoneUnderIndicator
extends GFX {
    private final FieldStackZone zone;
    private final Image texture;
    private final double offsetZ;
    private final int[] colorRGB;
    private ZoneUnderTypeIndicator indicator;

    public GFXZoneUnderIndicator(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, String textureName) {
        this(rolePlayer, location, textureName, 0.0, null);
    }

    public GFXZoneUnderIndicator(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, String textureName, double offsetZ) {
        this(rolePlayer, location, textureName, offsetZ, null);
    }

    public GFXZoneUnderIndicator(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, String textureName, double offsetZ, int[] colorRGB) {
        Zone zone = FieldData.getZoneByLocation(rolePlayer, location);
        if (!(zone instanceof FieldStackZone)) {
            throw new IllegalArgumentException();
        }
        FieldStackZone fieldStackZone = (FieldStackZone)zone;
        this.zone = fieldStackZone;
        this.texture = ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("zones/overlay/" + textureName));
        this.offsetZ = offsetZ;
        this.colorRGB = colorRGB;
    }

    @Override
    protected void onAttached() {
        this.indicator = new ZoneUnderTypeIndicator(this.texture, this.colorRGB == null ? null : Color.rgb((int)this.colorRGB[0], (int)this.colorRGB[1], (int)this.colorRGB[2]));
        this.indicator.setTransZ(this.offsetZ);
        this.zone.getZoneUnderCardsIndicators().getChildren().add((Object)this.indicator);
    }

    @Override
    protected void onDetached() {
        this.zone.getZoneUnderCardsIndicators().getChildren().remove((Object)this.indicator);
    }
}

