/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay;

import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.web.WebView;
import open.batoru.ImageCache;
import open.batoru.Settings;
import open.batoru.catalog.CardInformation;
import open.batoru.catalog.UtilCardDataFormatter;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.Disposable;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataColor;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.CardDataLRIGType;
import open.batoru.data.CardDataSIGNIClass;
import open.batoru.data.CardLoader;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.OutlinedText;
import open.batoru.ui.UtilDispose;

public class OverlayCardPreview
extends VBox
implements Disposable {
    private final ImageView cardImage;
    private final FlowPane containerLinkedCardImages;
    private final OutlinedText cardImageSetText;
    private final Button buttonCardWebInfo;
    private final Text nameText;
    private final Text typeText;
    private final Text colorText;
    private final Text levelText;
    private final TilePane costIcons;
    private final Text powerAndLimitText;
    private final Text LRIGTypeText;
    private final Text classText;
    private final WebView descriptionWebView;
    private ChangeListener<Boolean> listenerCardImageOnHover;
    private CardIndex lastCardIndex;
    private String lastImageSet;
    private boolean isLocked;

    public OverlayCardPreview() {
        this.setPickOnBounds(false);
        this.setPadding(new Insets(10.0));
        this.setAlignment(Pos.TOP_CENTER);
        this.setMaxWidth(250.0);
        this.setSpacing(10.0);
        StackPane imageContainer = new StackPane();
        imageContainer.setAlignment(Pos.TOP_CENTER);
        this.cardImage = new ImageView();
        this.cardImage.setFitWidth(175.0);
        this.cardImage.setFitHeight(244.0);
        this.cardImageSetText = new OutlinedText(1.5);
        this.cardImageSetText.getText().setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)14.0));
        this.cardImageSetText.getText().getStyleClass().add((Object)"ui_deck_panel_preview_imageset_text");
        this.cardImageSetText.setMouseTransparent(true);
        this.cardImageSetText.setVisible(Settings.INSTANCE.shouldAlwaysShowImageSetInPreview());
        this.listenerCardImageOnHover = (ov, oldValue, newValue) -> {
            if (!Settings.INSTANCE.shouldAlwaysShowImageSetInPreview()) {
                this.cardImageSetText.setVisible((boolean)newValue);
            }
        };
        this.cardImage.hoverProperty().addListener(this.listenerCardImageOnHover);
        this.buttonCardWebInfo = OverlayWindow.createButton("?");
        this.buttonCardWebInfo.setPadding(Insets.EMPTY);
        this.buttonCardWebInfo.setPrefSize(20.0, 20.0);
        this.buttonCardWebInfo.setMinWidth(20.0);
        this.buttonCardWebInfo.setVisible(false);
        StackPane.setAlignment((Node)this.buttonCardWebInfo, (Pos)Pos.TOP_RIGHT);
        this.buttonCardWebInfo.setOnAction(e -> {
            this.buttonCardWebInfo.setDisable(true);
            new CardInformation(this.buttonCardWebInfo, this.lastImageSet).show();
        });
        this.containerLinkedCardImages = new FlowPane(Orientation.VERTICAL);
        this.containerLinkedCardImages.setAlignment(Pos.BOTTOM_LEFT);
        this.containerLinkedCardImages.setHgap(4.0);
        this.containerLinkedCardImages.setVgap(4.0);
        this.containerLinkedCardImages.maxHeightProperty().bind((ObservableValue)imageContainer.heightProperty());
        UtilDispose.PERM.attachChildDisposeListener((Node)this.containerLinkedCardImages);
        imageContainer.getChildren().addAll((Object[])new Node[]{this.containerLinkedCardImages, this.cardImage, this.cardImageSetText, this.buttonCardWebInfo});
        GridPane infoGrid = new GridPane();
        infoGrid.setMinWidth(250.0);
        infoGrid.setMaxWidth(250.0);
        ColumnConstraints c1 = new ColumnConstraints();
        c1.setPercentWidth(35.0);
        ColumnConstraints c2 = new ColumnConstraints();
        c2.setPercentWidth(65.0);
        c2.setHalignment(HPos.RIGHT);
        infoGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{c1, c2});
        infoGrid.setPickOnBounds(false);
        Rectangle clip = new Rectangle(175.0, 244.0);
        clip.setArcWidth(21.0);
        clip.setArcHeight(21.0);
        this.cardImage.setClip((Node)clip);
        this.nameText = OverlayWindow.createText();
        this.nameText.setWrappingWidth(250.0);
        this.nameText.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
        this.typeText = OverlayWindow.createText();
        this.colorText = OverlayWindow.createText();
        this.levelText = OverlayWindow.createText();
        this.powerAndLimitText = OverlayWindow.createText();
        this.LRIGTypeText = OverlayWindow.createText();
        this.classText = OverlayWindow.createText();
        this.classText.setTextAlignment(TextAlignment.RIGHT);
        this.descriptionWebView = new WebView();
        this.descriptionWebView.setContextMenuEnabled(false);
        this.descriptionWebView.getEngine().setJavaScriptEnabled(false);
        this.descriptionWebView.setBlendMode(BlendMode.LIGHTEN);
        this.descriptionWebView.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.descriptionWebView.getEngine().loadContent("<body style=\"background:#000;\">");
        this.costIcons = new TilePane();
        this.costIcons.setId("game");
        this.costIcons.setAlignment(Pos.CENTER_RIGHT);
        this.costIcons.setHgap(2.0);
        this.costIcons.setVgap(2.0);
        this.costIcons.setPrefColumns(5);
        infoGrid.add((Node)this.typeText, 0, 0);
        infoGrid.add((Node)this.colorText, 1, 0);
        infoGrid.add((Node)this.levelText, 0, 2);
        infoGrid.add((Node)this.costIcons, 1, 2);
        infoGrid.add((Node)this.classText, 1, 2);
        infoGrid.add((Node)this.powerAndLimitText, 0, 3);
        infoGrid.add((Node)this.LRIGTypeText, 1, 3);
        this.getChildren().addAll((Object[])new Node[]{imageContainer, this.nameText, infoGrid, this.descriptionWebView});
    }

    public void setLock(boolean set) {
        this.isLocked = set;
    }

    public void update(CardIndex cardIndex) {
        if (cardIndex == null || cardIndex.getIndexedInstance() == null || this.isLocked) {
            return;
        }
        this.lastCardIndex = cardIndex;
        this.lastImageSet = cardIndex.getImageSet();
        this.updateTable(cardIndex.getCardReference(), cardIndex.getImageSet(), cardIndex.getIndexedInstance().getLRIGType(), cardIndex.getIndexedInstance().getSIGNIClass(), cardIndex.getIndexedInstance().getColor(), cardIndex.getIndexedInstance().getLevel().getValue(), cardIndex.getIndexedInstance().getLimit().getValue(), cardIndex.getIndexedInstance().getPower().getValue(), cardIndex.getIndexedInstance().getCost());
        this.descriptionWebView.getEngine().loadContent(DescriptionParser.GAME.parseDescription(cardIndex, true));
    }

    public void update(String imageSet) {
        if (this.isLocked) {
            return;
        }
        Card cardObject = CardLoader.getCardByImageSet(imageSet);
        if (cardObject == null) {
            return;
        }
        this.lastCardIndex = null;
        this.lastImageSet = imageSet;
        this.updateTable(cardObject, imageSet, cardObject.getLRIGType(), cardObject.getSIGNIClass(), cardObject.getColor(), cardObject.getLevel(), cardObject.getLimit(), cardObject.getPower(), cardObject.getCostAsDataCostLists());
        this.descriptionWebView.getEngine().loadContent(DescriptionParser.GAME.parseDescription(cardObject, true));
    }

    private void updateTable(Card cardObject, String imageSet, CardDataLRIGType cardLRIGType, CardDataSIGNIClass cardSIGNIClass, CardDataColor color, int level, double limit, double power, List<AbilityCostList> dataCostListsModified) {
        CardConst.CardType cardType = cardObject.getType();
        if (cardSIGNIClass.getPrimaryValue() != null) {
            this.classText.setOnMouseEntered(e -> this.classText.setText(UtilCardDataFormatter.formatSIGNIClassFamily(cardSIGNIClass)));
            this.classText.setOnMouseExited(e -> this.classText.setText(UtilCardDataFormatter.formatSIGNIClass(cardSIGNIClass)));
        }
        this.buttonCardWebInfo.setVisible(true);
        CardDataImageSet.MaskType maskType = CardLoader.getImageSetMaskType(imageSet);
        boolean hasVerticalImage = !CardConst.CardType.isCardInHorizontalOrientation(cardType) && maskType != CardDataImageSet.MaskType.VERTICAL;
        this.cardImage.setImage(ImageCache.INSTANCE.getCardImage(imageSet));
        this.cardImageSetText.setText(maskType != CardDataImageSet.MaskType.DOUBLE_FACED_UR ? imageSet : imageSet.substring(1));
        this.nameText.setText(cardObject.getName());
        this.typeText.setText(UtilCardDataFormatter.formatType(cardType));
        this.colorText.setText(UtilCardDataFormatter.formatColor(color));
        this.updateTextColorSimple(this.colorText, cardObject.getColor().getValue(), color.getValue());
        if (!this.containerLinkedCardImages.isHover()) {
            this.containerLinkedCardImages.getChildren().clear();
            List<String> linkedImageSets = cardObject.getLinkedImageSets();
            if (linkedImageSets != null) {
                this.containerLinkedCardImages.setOrientation(hasVerticalImage ? Orientation.VERTICAL : Orientation.HORIZONTAL);
                double sizeMulti = linkedImageSets.size() <= 5 ? 2.0 : 2.4;
                for (String linkedImageSet : linkedImageSets) {
                    ImageView linkedCardImage = new ImageView(ImageCache.INSTANCE.getCardImage(linkedImageSet));
                    linkedCardImage.setFitWidth(63.0 / sizeMulti);
                    linkedCardImage.setFitHeight(87.0 / sizeMulti);
                    Rectangle clip = new Rectangle(63.0 / sizeMulti, 87.0 / sizeMulti);
                    clip.setArcWidth(9.0 / sizeMulti);
                    clip.setArcHeight(9.0 / sizeMulti);
                    linkedCardImage.setClip((Node)clip);
                    Card linkedCardObject = CardLoader.getCardByImageSet(linkedImageSet);
                    if (linkedCardObject != null && CardConst.CardType.isCardInHorizontalOrientation(linkedCardObject.getType()) || CardLoader.getImageSetMaskType(linkedImageSet) == CardDataImageSet.MaskType.VERTICAL || !hasVerticalImage) {
                        linkedCardImage.setRotate(90.0);
                        FlowPane.setMargin((Node)linkedCardImage, (Insets)new Insets(0.0, hasVerticalImage ? 0.0 : 12.0, -6.0, 0.0));
                    }
                    linkedCardImage.setOnMouseEntered(e -> this.update(linkedImageSet));
                    UtilDispose.TEMP.setOnDisposed((Node)linkedCardImage, () -> {
                        linkedCardImage.setImage(null);
                        linkedCardImage.setOnMouseEntered(null);
                    });
                    this.containerLinkedCardImages.getChildren().add((Object)linkedCardImage);
                    if (this.containerLinkedCardImages.getChildren().size() <= 6) continue;
                    FlowPane.setMargin((Node)linkedCardImage, (Insets)new Insets(0.0, 0.0, 0.0, 191.0));
                }
                CardIndex refSourceCardIndex = this.lastCardIndex;
                this.containerLinkedCardImages.setOnMouseExited(e -> this.update(refSourceCardIndex));
            } else {
                this.containerLinkedCardImages.setOrientation(Orientation.HORIZONTAL);
                this.containerLinkedCardImages.setOnMouseExited(null);
            }
        }
        this.cardImage.setRotate(hasVerticalImage && (!this.containerLinkedCardImages.isHover() || this.containerLinkedCardImages.getOrientation() == Orientation.VERTICAL) ? 0.0 : 90.0);
        this.costIcons.getChildren().clear();
        if (cardType != CardConst.CardType.ARTS && cardType != CardConst.CardType.SPELL && cardType != CardConst.CardType.KEY && cardType != CardConst.CardType.PIECE) {
            if (cardType == CardConst.CardType.LRIG || cardType == CardConst.CardType.LRIG_ASSIST) {
                this.levelText.setText(UtilCardDataFormatter.formatLevel(level));
                if (cardObject.getCoins() > 0) {
                    this.levelText.setText(this.levelText.getText() + " " + UtilCardDataFormatter.formatCoins(cardObject.getCoins()));
                }
                this.powerAndLimitText.setText(UtilCardDataFormatter.formatLimit(limit, cardType == CardConst.CardType.LRIG_ASSIST));
                this.updateTextColor(this.levelText, cardObject.getLevel(), level);
                this.updateTextColor(this.powerAndLimitText, cardObject.getLimit(), limit);
                this.classText.setText("");
                this.LRIGTypeText.setText(UtilCardDataFormatter.formatLRIGType(cardLRIGType, false));
                UtilCardDataFormatter.formatCostIcons(this.costIcons, cardObject, dataCostListsModified);
            } else if (cardType != CardConst.CardType.TOKEN) {
                this.levelText.setText(UtilCardDataFormatter.formatLevel(level));
                if (cardObject.getLimit() > 0.0) {
                    this.levelText.setText(this.levelText.getText() + " " + UtilCardDataFormatter.formatLimit(limit, false));
                }
                this.powerAndLimitText.setText(UtilCardDataFormatter.formatPower(power));
                this.updateTextColor(this.levelText, cardObject.getLevel(), level);
                this.updateTextColor(this.powerAndLimitText, cardObject.getPower(), power);
                this.classText.setText(UtilCardDataFormatter.formatSIGNIClass(cardSIGNIClass));
                this.LRIGTypeText.setText(UtilCardDataFormatter.formatLRIGType(cardLRIGType, true));
                this.updateTextColorSimple(this.classText, cardObject.getSIGNIClass().getValue(), cardSIGNIClass.getValue());
            } else {
                this.colorText.setText("");
                this.levelText.setText("");
                this.powerAndLimitText.setText("");
                this.classText.setText("");
                this.LRIGTypeText.setText("");
            }
        } else {
            UtilCardDataFormatter.formatCostIcons(this.costIcons, cardObject, dataCostListsModified);
            this.levelText.setText("");
            this.powerAndLimitText.setText("");
            this.classText.setText("");
            this.LRIGTypeText.setText(UtilCardDataFormatter.formatLRIGType(cardLRIGType, true));
        }
    }

    private void updateTextColor(Text text, double valueOriginal, double valueModified) {
        if (valueModified == valueOriginal) {
            text.setFill((Paint)Color.WHITE);
        } else if (valueModified > valueOriginal) {
            text.setFill((Paint)Color.LIGHTGREEN);
        } else {
            text.setFill((Paint)Color.RED);
        }
    }

    private <T> void updateTextColorSimple(Text text, T valueOriginal, T valueModified) {
        text.setFill((Paint)(valueModified.equals(valueOriginal) ? Color.WHITE : Color.KHAKI));
    }

    public void updateCardImageSetTextVisibility(boolean isVisible) {
        this.cardImageSetText.setVisible(isVisible);
    }

    public CardIndex getLastCardIndex() {
        return this.lastCardIndex;
    }

    @Override
    public void dispose() {
        this.containerLinkedCardImages.maxHeightProperty().unbind();
        this.containerLinkedCardImages.getChildren().clear();
        this.containerLinkedCardImages.setOnMouseExited(null);
        UtilDispose.TEMP.detachChildDisposeListener((Node)this.containerLinkedCardImages);
        this.cardImage.setImage(null);
        this.cardImage.hoverProperty().removeListener(this.listenerCardImageOnHover);
        this.listenerCardImageOnHover = null;
        this.buttonCardWebInfo.setOnAction(null);
        this.descriptionWebView.prefHeightProperty().unbind();
        this.lastCardIndex = null;
    }
}

