/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay;

import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.actions.ActionGameEnd;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.networking.LogoutProcedure;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.UIConst;

public class OverlayDisconnectedScreen
extends StackPane
implements Disposable {
    private static final int DEFAULT_COUNTDOWN_TIMER = 120;
    private Text textTimer;
    private Button buttonExtendTimer;
    private Button buttonClose;
    private ScheduledExecutorService executorCountdownTimer;
    private int countdown = 120;
    private long timestampStarted;

    public OverlayDisconnectedScreen() {
        this.setBackground(UIConst.Style.BACKGROUND_OVERLAY);
        VBox content = new VBox();
        content.setAlignment(Pos.CENTER);
        content.setSpacing(10.0);
        Text text = new Text(LanguageParser.getString("UI_GAME_MESSAGE_DISCONNECT_WAIT"));
        text.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)16.0));
        text.setFill((Paint)Color.WHITE);
        content.getChildren().add((Object)text);
        if (Game.getCurrentGame().getFakeReceiver() == null) {
            this.textTimer = new Text("00:00");
            this.textTimer.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)36.0));
            this.textTimer.setFill((Paint)Color.KHAKI);
            this.buttonExtendTimer = OverlayWindow.createButton(LanguageParser.getString("UI_GAME_MESSAGE_DISCONNECT_BUTTON_EXTEND"));
            this.buttonExtendTimer.setOnAction(e -> {
                this.buttonExtendTimer.setDisable(true);
                this.countdown += 60;
            });
            content.getChildren().addAll((Object[])new Node[]{this.textTimer, this.buttonExtendTimer});
            StackPane.setMargin((Node)content, (Insets)new Insets(180.0, 0.0, 0.0, 0.0));
        } else {
            this.buttonClose = OverlayWindow.createButton(LanguageParser.getString("UI_GAME_MESSAGE_DISCONNECT_BUTTON_CLOSE"));
            this.buttonClose.setOnAction(e -> UI.getTabGame().closeGame(false));
            content.getChildren().add((Object)this.buttonClose);
            StackPane.setMargin((Node)content, (Insets)new Insets(140.0, 0.0, 0.0, 0.0));
        }
        this.getChildren().add((Object)content);
    }

    public void startCountdownTimer() {
        if (this.executorCountdownTimer != null || Game.getCurrentGame().getFakeReceiver() != null) {
            return;
        }
        this.timestampStarted = Instant.now().getEpochSecond();
        this.executorCountdownTimer = Executors.newScheduledThreadPool(1);
        this.executorCountdownTimer.scheduleAtFixedRate(() -> {
            if (Game.getCurrentGame() == null) {
                this.executorCountdownTimer.shutdown();
                this.executorCountdownTimer = null;
                return;
            }
            Platform.runLater(() -> {
                --this.countdown;
                this.textTimer.setText(String.format("%02d:%02d", this.countdown / 60, this.countdown % 60));
                if (this.countdown == 30) {
                    this.buttonExtendTimer.setDisable(false);
                } else if (this.countdown == 0) {
                    this.buttonExtendTimer.setDisable(true);
                    this.stopCountdownTimer();
                    ActionGameEnd.executeGameEnd(LanguageParser.getString("UI_GAME_WINSCREEN_WIN"));
                    UI.getTabGame().getFieldSceneOverlay().getWinScreen().receiveReplayData(null);
                    LogoutProcedure.disconnectGame();
                }
            });
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    public void stopCountdownTimer() {
        if (this.executorCountdownTimer == null) {
            return;
        }
        this.executorCountdownTimer.shutdown();
        this.executorCountdownTimer = null;
    }

    public boolean hasDefaultCountdownTimePassed() {
        return Instant.now().getEpochSecond() - this.timestampStarted >= 120L;
    }

    @Override
    public void dispose() {
        this.stopCountdownTimer();
        if (this.buttonExtendTimer != null) {
            this.buttonExtendTimer.setOnAction(null);
        }
        if (this.buttonClose != null) {
            this.buttonClose.setOnAction(null);
        }
    }
}

