/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Slider;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.util.StringConverter;
import open.batoru.Main;
import open.batoru.Settings;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.game.overlay.OverlayGameControls;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class OverlayReplayControls
extends StackPane
implements Disposable {
    private static final double ANI_SPEED_MIN = 0.1;
    private static final double ANI_SPEED_MAX = 1.0;
    private final Slider sliderGameSpeed;
    private ChangeListener<Number> listenerSlider;
    private final Button buttonPlayPause;
    private final Button buttonStop;
    private final Text textActionCounter;
    private final CheckBox checkBoxFastForwardMode;
    private final CheckBox checkBoxStepMode;
    private final int finalOrder;
    private EventHandler<KeyEvent> keyEventFilter;

    public OverlayReplayControls(int finalOrder) {
        this.finalOrder = finalOrder;
        this.setMaxWidth(75.0);
        this.setPickOnBounds(false);
        VBox boxControls = new VBox();
        boxControls.setAlignment(Pos.CENTER_LEFT);
        boxControls.setSpacing(10.0);
        boxControls.setPickOnBounds(false);
        this.sliderGameSpeed = new Slider(0.1, 1.0, Math.max(0.1, Math.min(1.0, 1.1 - Settings.INSTANCE.getAnimationSpeed())));
        this.sliderGameSpeed.setShowTickLabels(true);
        this.sliderGameSpeed.setShowTickMarks(true);
        this.sliderGameSpeed.setSnapToTicks(true);
        this.sliderGameSpeed.setMinorTickCount(8);
        this.sliderGameSpeed.setMajorTickUnit((double)0.45f);
        this.sliderGameSpeed.setMinHeight(400.0);
        this.sliderGameSpeed.setOrientation(Orientation.VERTICAL);
        this.sliderGameSpeed.setLabelFormatter((StringConverter)new StringConverter<Double>(this){

            public String toString(Double aDouble) {
                return aDouble == 0.1 ? LanguageParser.getString("UI_SETTINGS_SPEED_SLOWER") : (aDouble == 1.0 ? LanguageParser.getString("UI_SETTINGS_SPEED_FASTER") : "");
            }

            public Double fromString(String s) {
                return null;
            }
        });
        this.listenerSlider = (ov, oldValue, newValue) -> this.adjustGameSpeed(newValue.doubleValue());
        this.sliderGameSpeed.valueProperty().addListener(this.listenerSlider);
        this.textActionCounter = new Text("0 / " + finalOrder);
        this.textActionCounter.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
        this.textActionCounter.setFill((Paint)Color.WHITE);
        this.checkBoxFastForwardMode = new CheckBox("\u23e9");
        this.checkBoxFastForwardMode.setTextFill((Paint)Color.WHITE);
        this.checkBoxStepMode = new CheckBox(LanguageParser.getString("UI_REPLAY_STEP_MODE"));
        this.checkBoxStepMode.setTextFill((Paint)Color.WHITE);
        this.buttonPlayPause = OverlayGameControls.createButton("\u23f8");
        this.buttonPlayPause.setOnAction(e -> {
            if (UI.getTabGame().getFieldSceneOverlay().getWinScreen() != null) {
                return;
            }
            Game.getCurrentGame().getActionQueue().togglePause();
            if (!this.checkBoxStepMode.isSelected()) {
                this.buttonPlayPause.setText(this.buttonPlayPause.getText().equals("\u23f8") ? "\u23f5" : "\u23f8");
            }
        });
        this.checkBoxStepMode.setOnAction(e -> this.buttonPlayPause.setText(this.checkBoxStepMode.isSelected() ? "\u23ed" : "\u23f5"));
        this.checkBoxFastForwardMode.setOnAction(e -> {
            if (UI.getTabGame().getFieldSceneOverlay().getWinScreen() != null) {
                return;
            }
            if (this.checkBoxFastForwardMode.isSelected()) {
                this.sliderGameSpeed.setDisable(true);
                Game.getCurrentGame().getGameSpeedController().setMultiplier(0.01);
            } else {
                if (this.buttonPlayPause.getText().equals("\u23f8")) {
                    this.buttonPlayPause.fire();
                }
                this.sliderGameSpeed.setDisable(false);
                this.adjustGameSpeed(this.sliderGameSpeed.getValue());
            }
        });
        this.buttonStop = OverlayGameControls.createButton("\u23f9");
        this.buttonStop.setOnAction(e -> {
            if (UI.getTabGame().getFieldSceneOverlay().getWinScreen() != null) {
                return;
            }
            this.buttonPlayPause.setDisable(true);
            this.buttonStop.setDisable(true);
            Game.getCurrentGame().getActionQueue().setOnNextTaskEnd(() -> {
                Game.getCurrentGame().getActionQueue().stop();
                Platform.runLater(() -> UI.getTabGame().closeGame(false));
            });
        });
        boxControls.getChildren().addAll((Object[])new Node[]{this.checkBoxFastForwardMode, this.sliderGameSpeed, this.textActionCounter, this.checkBoxStepMode, this.buttonPlayPause, this.buttonStop});
        this.getChildren().add((Object)boxControls);
        this.keyEventFilter = e -> {
            if (e.getCode() == KeyCode.SPACE && UI.getCurrentTab() == UI.getTabGame()) {
                this.buttonPlayPause.fire();
                e.consume();
            }
        };
        Main.getStage().addEventFilter(KeyEvent.KEY_PRESSED, this.keyEventFilter);
    }

    private void adjustGameSpeed(double newValue) {
        Game.getCurrentGame().getGameSpeedController().setMultiplier(1.1 - newValue);
    }

    public void setCurrentOrder(int orderId) {
        this.textActionCounter.setText(orderId + " / " + this.finalOrder);
        if (this.checkBoxStepMode.isSelected()) {
            Game.getCurrentGame().getActionQueue().togglePause();
        }
    }

    @Override
    public void dispose() {
        this.buttonPlayPause.setOnAction(null);
        this.buttonStop.setOnAction(null);
        this.checkBoxStepMode.setOnAction(null);
        this.checkBoxFastForwardMode.setOnAction(null);
        this.sliderGameSpeed.valueProperty().removeListener(this.listenerSlider);
        this.listenerSlider = null;
        Main.getStage().removeEventFilter(KeyEvent.KEY_PRESSED, this.keyEventFilter);
        this.keyEventFilter = null;
    }
}

