/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay;

import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.game.overlay.OverlayGameControls;
import open.batoru.networking.SpecFakeGameReceiver;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class OverlaySpecControls
extends StackPane
implements Disposable {
    private final Text textSpecCount;
    private Button buttonClose;

    public OverlaySpecControls() {
        this.setMaxWidth(75.0);
        this.setPickOnBounds(false);
        VBox container = new VBox();
        container.setAlignment(Pos.TOP_CENTER);
        container.setSpacing(5.0);
        container.setPickOnBounds(false);
        this.textSpecCount = new Text();
        this.textSpecCount.setTextAlignment(TextAlignment.CENTER);
        this.textSpecCount.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)14.0));
        this.textSpecCount.setFill((Paint)Color.KHAKI);
        container.getChildren().add((Object)this.textSpecCount);
        if (Game.getCurrentGame().getFakeReceiver() instanceof SpecFakeGameReceiver) {
            this.buttonClose = OverlayGameControls.createButton("\u2716");
            this.buttonClose.setOnAction(e -> UI.getTabGame().closeGame(false));
            container.getChildren().add((Object)this.buttonClose);
        }
        this.getChildren().add((Object)container);
    }

    public void setSpecCount(int count) {
        this.textSpecCount.setText(LanguageParser.getString("UI_GAME_INFO_SPEC") + "\n\ud83d\udc41 " + count);
    }

    @Override
    public void dispose() {
        if (this.buttonClose != null) {
            this.buttonClose.setOnAction(null);
        }
    }
}

