/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.effects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableAnimation;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.effects.OverlayEffectsSidebarEntry;
import open.batoru.ui.UtilDispose;

public class AnimVBox
extends Region {
    private double spacing = 10.0;
    private final List<Runnable> mutationQueue = new ArrayList<Runnable>();
    private boolean isInAnimation;

    public AnimVBox() {
        this.setPickOnBounds(false);
    }

    public void setSpacing(double spacing) {
        this.spacing = spacing;
        this.requestLayout();
    }

    public void add(int arrayId, Node node) {
        if (!this.isInAnimation) {
            this.getChildren().add(arrayId == -1 ? this.getChildren().size() : arrayId, (Object)node);
        } else {
            this.mutationQueue.add(() -> this.getChildren().add((Object)node));
        }
    }

    public void remove(Node node) {
        if (!this.isInAnimation) {
            this.getChildren().remove((Object)node);
        } else {
            this.mutationQueue.add(() -> this.getChildren().remove((Object)node));
        }
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    protected void layoutChildren() {
        if (this.isInAnimation) {
            return;
        }
        double y = 0.0;
        for (Node child : this.getChildren()) {
            double height = child.prefHeight(-1.0);
            child.resizeRelocate(0.0, y, this.getWidth(), height);
            y += height + this.spacing;
        }
    }

    public void animateReorder(List<? extends Node> sortedNodes, double durationMillis) {
        this.isInAnimation = true;
        HashMap<Node, Double> startY = new HashMap<Node, Double>();
        HashMap<Node, Double> endY = new HashMap<Node, Double>();
        double y = 0.0;
        for (Node node : sortedNodes) {
            double height = node.prefHeight(-1.0);
            endY.put(node, y);
            y += height + this.spacing;
        }
        for (Node node : this.getChildren()) {
            startY.put(node, node.getLayoutY());
        }
        AnimationTracker tracker = new AnimationTracker(this.getChildren().size());
        TrackableSequentialTransition trackableSequentialTransition = new TrackableSequentialTransition(tracker, this.getChildren().size());
        for (int i = 0; i < this.getChildren().size(); ++i) {
            OverlayEffectsSidebarEntry entry = (OverlayEffectsSidebarEntry)this.getChildren().get(i);
            TrackableTranslateTransition ani = new TrackableTranslateTransition((Node)entry, durationMillis, (Double)startY.get(entry), (Double)endY.get(entry));
            ani.setAnimationTracker(tracker);
            trackableSequentialTransition.getAnimationList(i).add(ani);
        }
        tracker.setOnTrackerAllFinished(() -> {
            for (Node node : this.getChildren()) {
                node.setTranslateY(0.0);
            }
            UtilDispose.TEMP.suppressDispose(() -> this.getChildren().setAll((Collection)sortedNodes));
            this.requestLayout();
            for (Runnable r : this.mutationQueue) {
                r.run();
            }
            this.mutationQueue.clear();
            this.isInAnimation = false;
        });
        trackableSequentialTransition.play();
    }

    private static class TrackableTranslateTransition
    extends TrackableAnimation {
        private final Node node;
        private final double diffY;

        public TrackableTranslateTransition(Node node, double duration, double startY, double endY) {
            this.setStaticCycleDuration(duration);
            this.setInterpolator(Interpolator.LINEAR);
            this.node = node;
            this.diffY = endY - startY;
        }

        protected void interpolate(double frac) {
            this.node.setTranslateY(this.diffY * frac);
        }
    }
}

