/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.effects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import open.batoru.Log;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.data.DataTable;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ModalChoiceRepeatTracker;
import open.batoru.game.overlay.effects.AnimVBox;
import open.batoru.game.overlay.effects.OverlayEffectsSidebarEntry;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UtilDispose;

public class OverlayEffectsSidebar
extends VBox
implements Disposable {
    private final AnimVBox containerEffectsTop = new AnimVBox();
    private final AnimVBox containerEffectsBottom = new AnimVBox();
    private final StackPane nodeSeparator = new StackPane();

    public OverlayEffectsSidebar() {
        this.setSpacing(10.0);
        this.setMaxWidth(24.0);
        this.setPickOnBounds(false);
        this.nodeSeparator.setLayoutX(7.0);
        this.nodeSeparator.setMaxWidth(24.0);
        this.nodeSeparator.setMaxHeight(14.5);
        Text separator = new Text("\u25bc");
        separator.setFill((Paint)Color.KHAKI);
        separator.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (double)16.0));
        this.nodeSeparator.getChildren().add((Object)separator);
        this.getChildren().addAll((Object[])new Node[]{this.containerEffectsTop, this.nodeSeparator, this.containerEffectsBottom});
        this.setVisible(false);
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.containerEffectsTop);
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.containerEffectsBottom);
    }

    private AnimVBox getContainerByGroup(OverlayEffectsSidebarEntry entry) {
        return entry.isInTopGroup() ? this.containerEffectsTop : this.containerEffectsBottom;
    }

    private void removeFromEffectsContainer(OverlayEffectsSidebarEntry entry) {
        entry.hideEffectBalloon();
        this.getContainerByGroup(entry).remove((Node)entry);
    }

    private Optional<OverlayEffectsSidebarEntry> getEffectEntryBySource(Ability sourceAbility) {
        if (sourceAbility.getAbilityOwner() == Game.getCurrentGame().getGameRules().getTurnPlayer()) {
            return this.containerEffectsTop.getChildren().stream().map(OverlayEffectsSidebarEntry.class::cast).filter(e -> e.getSourceAbility() == sourceAbility).findFirst();
        }
        return this.containerEffectsBottom.getChildren().stream().map(OverlayEffectsSidebarEntry.class::cast).filter(e -> e.getSourceAbility() == sourceAbility).findFirst();
    }

    public void addEffect(Ability ability) {
        this.addEffect(ability, -1);
    }

    public void addEffect(Ability ability, int offset) {
        OverlayEffectsSidebarEntry entry = new OverlayEffectsSidebarEntry(ability);
        this.getContainerByGroup(entry).add(offset, (Node)entry);
        this.setVisible(true);
    }

    public void confirmNonMandatoryEffect(Ability ability) {
        this.getEffectEntryBySource(ability).ifPresent(entry -> entry.setOpacity(1.0));
    }

    public void removeEffect(Ability ability) {
        this.getEffectEntryBySource(ability).ifPresent(entry -> {
            this.removeFromEffectsContainer((OverlayEffectsSidebarEntry)entry);
            if (this.containerEffectsTop.getChildren().isEmpty() && this.containerEffectsBottom.getChildren().isEmpty()) {
                this.setVisible(false);
            }
        });
    }

    public void setEffectAsWaitingCutInResponse(Ability ability, boolean set) {
        this.getEffectEntryBySource(ability).ifPresent(entry -> entry.setAsWaitingCutInResponse(set));
    }

    public void reorderEffects(EffectBucket sourceBucket, DataTable<Integer> dataSortedOrderDiffs) {
        AnimVBox container;
        boolean isTop = Game.getCurrentGame().getGameRules().getEffectProcessor().getTurnPlayerBucket() == sourceBucket;
        AnimVBox animVBox = container = isTop ? this.containerEffectsTop : this.containerEffectsBottom;
        if (dataSortedOrderDiffs.size() - 1 != container.getChildren().size()) {
            Log.printMessage(true, "Warning: Effect order list differs from side bar list. (" + dataSortedOrderDiffs.size() + " != " + container.getChildren().size() + ")");
            return;
        }
        for (Node node : container.getChildren()) {
            ((OverlayEffectsSidebarEntry)node).hideEffectBalloon();
        }
        ArrayList<Object> newOrder = new ArrayList<Object>(Collections.nCopies(container.getChildren().size(), null));
        for (int i = 0; i < container.getChildren().size(); ++i) {
            int diff = dataSortedOrderDiffs.get(i);
            int newIndex = i + diff;
            newOrder.set(newIndex, ((OverlayEffectsSidebarEntry)container.getChildren().get(i)));
        }
        container.animateReorder(newOrder, 100.0);
    }

    public void setEffectChosenModes(Ability ability, int bitsModes, ModalChoiceRepeatTracker choiceRepeatTracker) {
        this.getEffectEntryBySource(ability).ifPresent(entry -> entry.setChosenModes(bitsModes, choiceRepeatTracker));
    }

    public void setEffectChosenOption(Ability ability, String option) {
        this.getEffectEntryBySource(ability).ifPresent(entry -> entry.setChosenOption(option));
    }

    public void setEffectChosenTarget(Ability ability, Game.GamePlayerRole sourceTargetRole, CardIndex target) {
        this.getEffectEntryBySource(ability).ifPresent(entry -> entry.setChosenTarget(sourceTargetRole, target));
    }

    public final void clearAll() {
        this.setVisible(false);
        this.containerEffectsTop.getChildren().clear();
        this.containerEffectsBottom.getChildren().clear();
        this.nodeSeparator.setLayoutY(0.0);
    }

    @Override
    public void dispose() {
        this.containerEffectsTop.getChildren().clear();
        this.containerEffectsBottom.getChildren().clear();
    }
}

