/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.effects;

import java.lang.runtime.SwitchBootstraps;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.ImageCache;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.CardLoader;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ActionAbility;
import open.batoru.data.ability.AutoAbility;
import open.batoru.data.ability.EnterAbility;
import open.batoru.data.ability.LifeBurstAbility;
import open.batoru.data.ability.ModalChoiceRepeatTracker;
import open.batoru.game.FieldZone;
import open.batoru.game.Zone;
import open.batoru.game.animations.AnimationUITextFlash;
import open.batoru.game.overlay.effects.OverlayEffectsSidebarBalloon;
import open.batoru.game.overlay.log.events.LogEventPlayerChoiceModes;
import open.batoru.game.overlay.log.events.LogEventPlayerChoiceOption;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.UIConst;
import open.batoru.ui.UtilDispose;

public class OverlayEffectsSidebarEntry
extends HBox
implements Disposable {
    private Ability ability;
    private OverlayEffectsSidebarBalloon balloon;
    private boolean isBalloonLocked;
    private Text textCutInResponse;
    private AnimationUITextFlash aniCutInTextFlash;
    private final boolean isInTopGroup;

    public OverlayEffectsSidebarEntry(Ability ability) {
        this.setAlignment(Pos.CENTER_LEFT);
        this.setSpacing(5.0);
        this.ability = ability;
        if (!EffectBucket.isAbilityMandatory(ability)) {
            this.setOpacity(0.5);
        }
        this.isInTopGroup = Game.getCurrentGame().getGameRules().getEffectProcessor().getSourceBucket(ability) == Game.getCurrentGame().getGameRules().getEffectProcessor().getTurnPlayerBucket();
        this.addCardImage();
    }

    public boolean isInTopGroup() {
        return this.isInTopGroup;
    }

    private void addCardImage() {
        StackPane containerImage = new StackPane();
        Ability ability = this.ability;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnterAbility.class, AutoAbility.class, ActionAbility.class}, (Object)ability, n)) {
            case 0: {
                EnterAbility ignored = (EnterAbility)ability;
                containerImage.setBackground(UIConst.Style.BACKGROUND_ABILITY_ENTER);
                break;
            }
            case 1: {
                AutoAbility ignored = (AutoAbility)ability;
                containerImage.setBackground(UIConst.Style.BACKGROUND_ABILITY_AUTO);
                break;
            }
            case 2: {
                ActionAbility ignored = (ActionAbility)ability;
                containerImage.setBackground(UIConst.Style.BACKGROUND_ABILITY_ACTION);
                break;
            }
            default: {
                containerImage.setBackground(UIConst.Style.BACKGROUND_WHITE);
            }
        }
        String imageSet = this.ability.getSourceCardIndex().getImageSet();
        ImageView image = new ImageView(ImageCache.INSTANCE.getCardImage(imageSet != null ? imageSet : this.ability.getCachedSourceCardImageSet()));
        image.setFitWidth(21.0);
        image.setFitHeight(29.0);
        if (this.ability.getSourceCardIndex().getCardReference() == null || !CardConst.CardType.isCardInHorizontalOrientation(this.ability.getSourceCardIndex().getCardReference().getType()) && CardLoader.getImageSetMaskType(this.ability.getSourceCardIndex().getImageSet()) != CardDataImageSet.MaskType.VERTICAL) {
            containerImage.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        } else {
            containerImage.setPadding(new Insets(0.0, 0.0, 3.0, 0.0));
            containerImage.setRotate(90.0);
        }
        containerImage.getChildren().add((Object)image);
        containerImage.setOnMouseEntered(e -> {
            if (!this.isBalloonLocked) {
                this.showEffectBalloon();
            }
            if (this.ability.getSourceCardIndex().getIndexedInstance() != null) {
                UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.ability.getSourceCardIndex());
            } else {
                UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.ability.getCachedSourceCardImageSet());
            }
        });
        containerImage.setOnMouseExited(e -> {
            if (!this.isBalloonLocked) {
                this.hideEffectBalloon();
            }
        });
        containerImage.setOnMouseClicked(e -> {
            this.isBalloonLocked = !this.isBalloonLocked;
        });
        UtilDispose.TEMP.setOnDisposed((Node)containerImage, () -> {
            containerImage.setOnMouseEntered(null);
            containerImage.setOnMouseExited(null);
            containerImage.setOnMouseClicked(null);
            image.setImage(null);
        });
        this.getChildren().add((Object)containerImage);
        if (this.ability instanceof LifeBurstAbility) {
            ImageView imageLB = new ImageView(ImageCache.INSTANCE.getImageIcon("lifeburst"));
            this.getChildren().add((Object)imageLB);
        }
    }

    public void showEffectBalloon() {
        if (this.balloon != null) {
            this.hideEffectBalloon();
        }
        this.balloon = new OverlayEffectsSidebarBalloon(this.ability);
        Pane effectsPane = UI.getTabGame().getFieldSceneOverlay().getEffectsPane();
        effectsPane.getChildren().add((Object)this.balloon);
        this.balloon.setLayoutX(40.0);
        Bounds entryBounds = this.localToScene(this.getBoundsInLocal());
        Bounds paneBounds = effectsPane.localToScene(effectsPane.getBoundsInLocal());
        this.balloon.setLayoutY(entryBounds.getMinY() - paneBounds.getMinY());
        UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.ability.getSourceCardIndex());
        Zone zone = this.ability.getSourceCardIndex().getZoneByLocation();
        if (zone instanceof FieldZone) {
            FieldZone fieldZone = (FieldZone)zone;
            fieldZone.installZoneHighlighter();
        }
    }

    public void hideEffectBalloon() {
        if (this.balloon == null) {
            return;
        }
        UI.getTabGame().getFieldSceneOverlay().getEffectsPane().getChildren().remove((Object)this.balloon);
        this.balloon = null;
        Zone zone = this.ability.getSourceCardIndex().getZoneByLocation();
        if (zone instanceof FieldZone) {
            FieldZone fieldZone = (FieldZone)zone;
            fieldZone.uninstallZoneHighlighter();
        }
    }

    public void setAsWaitingCutInResponse(boolean set) {
        if (set && this.textCutInResponse == null) {
            this.textCutInResponse = new Text("\ud83d\uddf2");
            this.textCutInResponse.setFont(Font.loadFont((String)"file:fonts/Symbola-12.ttf", (double)16.0));
            this.textCutInResponse.setFill((Paint)Color.KHAKI);
            this.aniCutInTextFlash = new AnimationUITextFlash(null, this.textCutInResponse);
            this.aniCutInTextFlash.play();
            this.getChildren().add(1, (Object)this.textCutInResponse);
        } else if (!set && this.textCutInResponse != null) {
            this.aniCutInTextFlash.stop();
            this.getChildren().remove((Object)this.textCutInResponse);
        }
    }

    public void setChosenModes(int bitsModes, ModalChoiceRepeatTracker choiceRepeatTracker) {
        for (int i = 1; i <= bitsModes; i <<= 1) {
            if ((bitsModes & i) == 0) continue;
            int repeats = choiceRepeatTracker == null ? 0 : choiceRepeatTracker.getChoiceRepeats(Integer.numberOfTrailingZeros(i));
            for (int ii = 0; ii < 1 + repeats; ++ii) {
                Text text = new Text(String.valueOf(Character.toChars(10102 + Integer.numberOfTrailingZeros(i))));
                text.setFont(Font.font((double)16.0));
                text.setFill((Paint)Color.KHAKI);
                this.getChildren().add((Object)text);
            }
        }
        UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(new LogEventPlayerChoiceModes(this.ability.getAbilityOwner(), bitsModes, choiceRepeatTracker));
    }

    public void setChosenOption(String option) {
        StackPane container = new StackPane();
        container.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        container.setBackground(UIConst.Style.BACKGROUND_KHAKI);
        Text text = new Text(option);
        text.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)14.0));
        container.getChildren().add((Object)text);
        this.getChildren().add((Object)container);
        UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(new LogEventPlayerChoiceOption(this.ability.getAbilityOwner(), option));
    }

    public void setChosenTarget(Game.GamePlayerRole sourceTargetRole, CardIndex target) {
        StackPane container = new StackPane();
        container.setAlignment(Pos.TOP_LEFT);
        Text textIconTarget = new Text("\ud83c\udfaf");
        textIconTarget.setFont(Font.loadFont((String)"file:fonts/Symbola-12.ttf", (double)16.0));
        textIconTarget.setFill((Paint)(sourceTargetRole != Game.getCurrentGame().getPlayerRole() ? Color.RED : Color.LIGHTGREEN));
        textIconTarget.setMouseTransparent(true);
        StackPane containerImage = new StackPane();
        containerImage.setAlignment(Pos.BOTTOM_RIGHT);
        StackPane containerImageBackground = new StackPane();
        containerImageBackground.setMaxSize((double)12.6f, (double)17.4f);
        containerImageBackground.setPadding(new Insets(0.0, 0.0, 1.0, 0.0));
        containerImageBackground.setBackground(this.ability.getAbilityOwner() == target.getIndexedInstance().getCurrentOwner() ? UIConst.Style.BACKGROUND_GREEN_LIGHT : UIConst.Style.BACKGROUND_RED_DEEP);
        String imageSet = target.getImageSet();
        ImageView image = new ImageView(ImageCache.INSTANCE.getCardImage(imageSet));
        image.setFitWidth((double)12.6f);
        image.setFitHeight((double)17.4f);
        containerImageBackground.getChildren().add((Object)image);
        containerImage.getChildren().add((Object)containerImageBackground);
        containerImage.setOnMouseEntered(e -> {
            if (target.getIndexedInstance() != null) {
                UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(target);
            } else {
                UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(imageSet);
            }
            Zone patt0$temp = target.getZoneByLocation();
            if (patt0$temp instanceof FieldZone) {
                FieldZone fieldZone = (FieldZone)patt0$temp;
                fieldZone.installZoneHighlighter();
            }
        });
        container.getChildren().addAll((Object[])new Node[]{containerImage, textIconTarget});
        UtilDispose.TEMP.setOnDisposed((Node)container, () -> {
            containerImage.setOnMouseEntered(null);
            image.setImage(null);
        });
        this.getChildren().add((Object)container);
    }

    public Ability getSourceAbility() {
        return this.ability;
    }

    @Override
    public void dispose() {
        UtilDispose.TEMP.attachChildDisposeListener((Node)this);
        this.getChildren().clear();
        UtilDispose.TEMP.detachChildDisposeListener((Node)this);
        this.ability = null;
        if (this.aniCutInTextFlash != null) {
            this.aniCutInTextFlash.stop();
            this.aniCutInTextFlash = null;
        }
    }
}

