/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.web.WebView;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.ui.UIConst;

public abstract class LogEntry
extends StackPane {
    private Text textDisabled;
    private boolean isDisabled;

    public LogEntry() {
        this.setBorder(UIConst.Style.BORDER_GAME_LOG_ENTRY);
        this.setMaxWidth(315.0);
    }

    public void disable() {
        if (this.isDisabled) {
            return;
        }
        this.isDisabled = true;
        this.getChildren().forEach(node -> {
            node.setUserData((Object)node.getOpacity());
            node.setOpacity(0.75);
        });
        this.textDisabled = new Text("\u2718");
        this.textDisabled.setFont(Font.font((String)"file:fonts/Symbola-12.ttf", (double)84.0));
        this.textDisabled.setFill((Paint)Color.RED);
        this.textDisabled.setStroke((Paint)Color.DARKRED);
        this.textDisabled.setStrokeWidth(3.0);
        this.getChildren().add((Object)this.textDisabled);
        StackPane.setAlignment((Node)this.textDisabled, (Pos)Pos.CENTER);
    }

    public void enable() {
        if (!this.isDisabled) {
            return;
        }
        this.isDisabled = false;
        this.getChildren().forEach(node -> {
            if (node.getUserData() != null) {
                node.setOpacity(((Double)node.getUserData()).doubleValue());
            }
        });
        this.getChildren().remove((Object)this.textDisabled);
    }

    public static StackPane createGradientBackground(boolean isLeft, boolean isGreen) {
        StackPane containerBackground = new StackPane();
        containerBackground.setMaxWidth(51.580000000000005);
        containerBackground.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)new LinearGradient(isLeft ? 0.0 : 1.0, 0.0, isLeft ? 1.0 : 0.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, isGreen ? Color.rgb((int)0, (int)255, (int)0, (double)0.25) : Color.rgb((int)255, (int)0, (int)0, (double)0.25)), new Stop(1.0, Color.TRANSPARENT)}), null, null)}));
        StackPane.setAlignment((Node)containerBackground, (Pos)(isLeft ? Pos.CENTER_LEFT : Pos.CENTER_RIGHT));
        return containerBackground;
    }

    public static ImageView createCardImage(String imageSet) {
        return OverlayWindow.createCardImage(imageSet);
    }

    public static StackPane createCardAbilityDescription(String description) {
        StackPane container = new StackPane();
        container.setPadding(new Insets(5.0));
        container.setAlignment(Pos.BOTTOM_CENTER);
        container.setMinHeight(80.0);
        container.setMaxHeight(80.0);
        WebView webView = new WebView();
        webView.setContextMenuEnabled(false);
        webView.getEngine().setJavaScriptEnabled(false);
        webView.getEngine().loadContent(DescriptionParser.GAME.parseDescription(description));
        container.getChildren().add((Object)webView);
        return container;
    }
}

