/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.core.Game;
import open.batoru.data.ability.ModalChoiceRepeatTracker;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.parsers.LanguageParser;

public class LogEntryPlayerChoiceModes
extends LogEntry {
    public LogEntryPlayerChoiceModes(Game.GamePlayerRole rolePlayer, int bitsModes, ModalChoiceRepeatTracker choiceRepeatTracker) {
        this.setPadding(new Insets(5.0));
        if (rolePlayer == Game.getCurrentGame().getPlayerRole()) {
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)0, (int)255, (int)0, (double)0.25), null, null)}));
        } else {
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)255, (int)0, (int)0, (double)0.25), null, null)}));
        }
        String username = Game.getCurrentGame().getRoom().getPlayerData(rolePlayer).getPlayerName();
        HBox content = new HBox();
        content.setAlignment(Pos.CENTER_LEFT);
        content.setSpacing(5.0);
        Text textChoice = new Text("\ud83d\udc49 " + username + " " + LanguageParser.getString("UI_GAME_LOG_PLAYER_CHOICE"));
        textChoice.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
        textChoice.setFill((Paint)Color.KHAKI);
        content.getChildren().add((Object)textChoice);
        for (int i = 1; i <= bitsModes; i <<= 1) {
            if ((bitsModes & i) == 0) continue;
            int repeats = choiceRepeatTracker == null ? 0 : choiceRepeatTracker.getChoiceRepeats(Integer.numberOfTrailingZeros(i));
            for (int ii = 0; ii < 1 + repeats; ++ii) {
                Text text = new Text(String.valueOf(Character.toChars(10102 + Integer.numberOfTrailingZeros(i))));
                text.setFont(Font.font((double)20.0));
                text.setFill((Paint)Color.KHAKI);
                content.getChildren().add((Object)text);
            }
        }
        this.getChildren().add((Object)content);
    }
}

