/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.core.Game;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UIConst;

public class LogEntryPlayerChoiceOption
extends LogEntry {
    public LogEntryPlayerChoiceOption(Game.GamePlayerRole rolePlayer, String option) {
        this.setPadding(new Insets(5.0));
        if (rolePlayer == Game.getCurrentGame().getPlayerRole()) {
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)0, (int)255, (int)0, (double)0.25), null, null)}));
        } else {
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)255, (int)0, (int)0, (double)0.25), null, null)}));
        }
        String username = Game.getCurrentGame().getRoom().getPlayerData(rolePlayer).getPlayerName();
        HBox content = new HBox();
        content.setAlignment(Pos.CENTER_LEFT);
        content.setSpacing(5.0);
        Text textChoice = new Text("\ud83d\udc49 " + username + " " + LanguageParser.getString("UI_GAME_LOG_PLAYER_CHOICE"));
        textChoice.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
        textChoice.setFill((Paint)Color.KHAKI);
        StackPane containerOption = new StackPane();
        containerOption.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        containerOption.setBackground(UIConst.Style.BACKGROUND_KHAKI);
        Text textOption = new Text(option);
        textOption.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)14.0));
        containerOption.getChildren().add((Object)textOption);
        content.getChildren().addAll((Object[])new Node[]{textChoice, containerOption});
        this.getChildren().add((Object)content);
    }
}

