/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log;

import java.util.Map;
import java.util.WeakHashMap;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import open.batoru.ImageCache;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.game.animations.AnimationOverlayGameSidePanelToggle;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.game.overlay.log.OverlayGameLogExcludedCardsTracker;
import open.batoru.game.overlay.log.OverlayGameLogLifeClothTracker;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.UIConst;
import open.batoru.ui.UtilDispose;

public class OverlayGameLog
extends StackPane
implements Disposable {
    private final ListView<LogEvent> listView = new ListView();
    private final Map<LogEvent, LogEntry> cachedEntries = new WeakHashMap<LogEvent, LogEntry>();
    private LogEvent lastLogEvent;
    private int lastScrolledItem;
    private boolean toggled;
    private AnimationOverlayGameSidePanelToggle aniToggle;
    private final OverlayGameLogExcludedCardsTracker trackerExcludedCards = new OverlayGameLogExcludedCardsTracker();
    private final OverlayGameLogLifeClothTracker trackerTopLC = new OverlayGameLogLifeClothTracker(true);
    private final OverlayGameLogLifeClothTracker trackerBottomLC = new OverlayGameLogLifeClothTracker(false);

    public OverlayGameLog() {
        this.setMinWidth(340.0);
        this.setMaxWidth(this.getMinWidth());
        ImageView borderTop = new ImageView(ImageCache.INSTANCE.getImage("overlay/border0.png"));
        ImageView borderBottom = new ImageView(ImageCache.INSTANCE.getImage("overlay/border0.png"));
        borderBottom.setRotate(180.0);
        borderBottom.setMouseTransparent(true);
        VBox content = new VBox();
        content.setAlignment(Pos.TOP_CENTER);
        content.setBorder(UIConst.Style.BORDER_OVERLAY);
        content.setBackground(UIConst.Style.BACKGROUND_OVERLAY);
        this.trackerTopLC.setBorder(new Border(new BorderStroke[]{new BorderStroke(null, null, (Paint)Color.GREY, null, BorderStrokeStyle.NONE, BorderStrokeStyle.NONE, BorderStrokeStyle.SOLID, BorderStrokeStyle.NONE, null, BorderWidths.DEFAULT, null)}));
        this.trackerBottomLC.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.GREY, null, null, null, BorderStrokeStyle.SOLID, BorderStrokeStyle.NONE, BorderStrokeStyle.NONE, BorderStrokeStyle.NONE, null, BorderWidths.DEFAULT, null)}));
        Text textTitle = new Text(LanguageParser.getString("UI_GAME_LOG"));
        textTitle.setTextAlignment(TextAlignment.CENTER);
        textTitle.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)16.0));
        textTitle.setFill((Paint)Color.KHAKI);
        this.listView.setStyle("-fx-background-color: transparent; -fx-control-inner-background: transparent;");
        this.listView.setFocusTraversable(false);
        this.listView.setSelectionModel(null);
        this.listView.setCellFactory(list -> new ListCell<LogEvent>(){
            private LogEvent lastItem;
            {
                this.setStyle("-fx-background-color: transparent;");
                this.setPadding(Insets.EMPTY);
                this.setFocusTraversable(false);
            }

            protected void updateItem(LogEvent item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setGraphic(null);
                } else {
                    if (item == this.lastItem) {
                        return;
                    }
                    this.setGraphic((Node)OverlayGameLog.this.cachedEntries.computeIfAbsent(item, logEvent -> {
                        LogEntry entry = logEvent.createNewLogEntry();
                        if (logEvent.isRuleCheck()) {
                            entry.setOpacity(0.6);
                        }
                        logEvent.setSourceEntry(entry);
                        return entry;
                    }));
                    this.lastItem = item;
                }
            }
        });
        VBox.setVgrow(this.listView, (Priority)Priority.ALWAYS);
        content.getChildren().addAll((Object[])new Node[]{this.trackerTopLC, textTitle, this.listView, this.trackerBottomLC});
        StackPane.setMargin((Node)content, (Insets)new Insets(20.0, 0.0, 20.0, 0.0));
        StackPane.setAlignment((Node)borderTop, (Pos)Pos.TOP_CENTER);
        StackPane.setAlignment((Node)borderBottom, (Pos)Pos.BOTTOM_CENTER);
        StackPane.setMargin(this.listView, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        StackPane.setAlignment(this.listView, (Pos)Pos.BOTTOM_CENTER);
        this.getChildren().addAll((Object[])new Node[]{content, this.trackerExcludedCards, borderTop, borderBottom});
        this.trackerExcludedCards.setVisible(false);
        this.trackerExcludedCards.setManaged(false);
        StackPane.setMargin((Node)this.trackerExcludedCards, (Insets)new Insets(0.0, 0.0, 0.0, -32.0));
        StackPane.setAlignment((Node)this.trackerExcludedCards, (Pos)Pos.CENTER_LEFT);
        this.setVisible(false);
        this.setManaged(false);
    }

    public void addEntry(LogEvent logEvent) {
        this.addEntry(logEvent, false);
    }

    public void addEntry(LogEvent logEvent, boolean isRuleCheckEntry) {
        if (logEvent == null) {
            return;
        }
        this.listView.getItems().add((Object)logEvent);
        this.lastLogEvent = logEvent;
        logEvent.setIsRuleCheck(isRuleCheckEntry);
        if (this.isVisible() && !this.isHover()) {
            if (Game.getCurrentGame().getGameSpeedController().getMultiplier() == 0.01 && this.listView.getItems().size() - this.lastScrolledItem < 20) {
                return;
            }
            this.lastScrolledItem = this.listView.getItems().size() - 1;
            this.listView.scrollTo(this.lastScrolledItem);
        }
    }

    public LogEvent getLastLogEvent() {
        return this.lastLogEvent;
    }

    public void scrollTo(LogEvent logEvent) {
        this.listView.scrollTo((Object)logEvent);
    }

    public void toggle() {
        if (this.aniToggle != null) {
            this.aniToggle.stop();
        }
        boolean bl = this.toggled = !this.toggled;
        if (Game.getCurrentGame().getGameServerPortOffset() != 0) {
            UI.getTabGame().getFieldSceneOverlay().setReportButtonVisible(!this.toggled);
        }
        this.aniToggle = new AnimationOverlayGameSidePanelToggle(this, this.toggled);
        if (this.toggled) {
            this.setVisible(true);
            this.setManaged(true);
            this.listView.scrollTo(this.listView.getItems().size() - 1);
        } else {
            this.aniToggle.setOnFinished(e -> {
                this.setVisible(false);
                this.setManaged(false);
            });
        }
        this.aniToggle.play();
    }

    public OverlayGameLogExcludedCardsTracker getExcludedCardsTracker() {
        return this.trackerExcludedCards;
    }

    public OverlayGameLogLifeClothTracker getLifeClothTracker(Game.GamePlayerRole rolePlayer) {
        return rolePlayer != Game.getCurrentGame().getPlayerRole() ? this.trackerTopLC : this.trackerBottomLC;
    }

    @Override
    public void dispose() {
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.trackerExcludedCards);
        this.trackerExcludedCards.getChildren().clear();
        Pane trackerTopLCContent = (Pane)this.trackerTopLC.getContent();
        UtilDispose.TEMP.attachChildDisposeListener((Node)trackerTopLCContent);
        trackerTopLCContent.getChildren().clear();
        Pane trackerBottomLCContent = (Pane)this.trackerBottomLC.getContent();
        UtilDispose.TEMP.attachChildDisposeListener((Node)trackerBottomLCContent);
        trackerBottomLCContent.getChildren().clear();
        this.listView.getItems().forEach(LogEvent::dispose);
        this.listView.getItems().clear();
        this.cachedEntries.values().forEach(entry -> {
            if (entry instanceof Disposable) {
                Disposable disposable = (Disposable)((Object)entry);
                disposable.dispose();
            }
        });
        this.cachedEntries.clear();
        this.lastLogEvent = null;
        if (this.aniToggle != null) {
            this.aniToggle.setOnFinished(null);
            this.aniToggle.stop();
            this.aniToggle = null;
        }
    }
}

