/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log.events;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.events.EventAttack;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.game.overlay.log.LogEntryCard;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.parsers.LanguageParser;

public class LogEventAttackLRIG
extends LogEvent {
    private final boolean isOwnCard;
    private final String imageSet;
    private final String cardName;

    public LogEventAttackLRIG(EventAttack event) {
        CardIndex cardIndex = event.getCaller().getSourceCardIndex();
        this.isOwnCard = CardIndex.isOwnCard(cardIndex);
        this.imageSet = cardIndex.getImageSet();
        this.cardName = cardIndex.getCardReference().getName();
    }

    @Override
    public LogEntry createNewLogEntry() {
        LogEntryCard entry = new LogEntryCard(this.isOwnCard, this.imageSet, this.cardName, LanguageParser.getString("UI_GAME_LOG_CARD_ATTACK"), LogEntryCard.ArrowsDirection.RIGHT);
        entry.addText(GameConst.CardLocation.getIconByLocation(GameConst.CardLocation.LRIG));
        return entry;
    }
}

