/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log.events;

import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.ability.events.EventActivateAbility;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.game.overlay.log.LogEntryAbility;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.game.overlay.log.events.LogEventEffectTrigger;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class LogEventEffectResolve
extends LogEvent {
    private final boolean isOwnCard;
    private String imageSet;
    private String cardName;
    private String abilityDescription;
    private boolean isCompactEntry;

    public LogEventEffectResolve(EventActivateAbility event) {
        LogEventEffectTrigger logEventEffectTrigger;
        CardIndex cardIndex = event.getCaller().getSourceCardIndex();
        this.isOwnCard = CardIndex.isOwnCard(cardIndex);
        LogEvent logEvent = UI.getTabGame().getFieldSceneOverlay().getGameLog().getLastLogEvent();
        if (logEvent instanceof LogEventEffectTrigger && (logEventEffectTrigger = (LogEventEffectTrigger)logEvent).getAbility() == event.getSourceAbility()) {
            this.isCompactEntry = true;
        } else {
            this.imageSet = cardIndex.getImageSet() != null ? cardIndex.getImageSet() : event.getSourceAbility().getCachedSourceCardImageSet();
            this.cardName = cardIndex.getCardReference() != null ? cardIndex.getCardReference().getName() : event.getSourceAbility().getCachedSourceCardName();
            this.abilityDescription = event.getSourceAbility().getCachedAbilityDescription();
        }
    }

    @Override
    public LogEntry createNewLogEntry() {
        LogEntryAbility entry = this.isCompactEntry ? new LogEntryAbility(this.isOwnCard) : new LogEntryAbility(this.isOwnCard, this.imageSet, this.cardName, this.abilityDescription, "\ud83d\uddf2 " + LanguageParser.getString("UI_GAME_LOG_ABILITY_RESOLVE") + ":");
        entry.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)128, (int)128, (int)0, (double)0.2), null, null)}));
        return entry;
    }
}

