/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log.events;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Pair;
import open.batoru.ImageCache;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.actions.ActionEnerPay;
import open.batoru.data.CardConst;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.game.overlay.log.LogEntryCard;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.parsers.LanguageParser;

public class LogEventPayEner
extends LogEvent
implements Disposable {
    private final boolean isOwnCard;
    private final String imageSet;
    private final String cardName;
    private String abilityDescription;
    private boolean hasCost;
    private boolean isGuard;
    private final List<Pair<String, CardConst.CardColor>> snapshotPaidEnerData = new ArrayList<Pair<String, CardConst.CardColor>>();
    private final List<ImageView> listCardImages = new ArrayList<ImageView>();

    public LogEventPayEner(CardIndex cardIndex, List<ActionEnerPay.PaidEnerData> listPaidEnerData) {
        this(cardIndex, null, null, listPaidEnerData);
    }

    public LogEventPayEner(CardIndex cardIndex, Ability sourceAbility, AbilityCost sourceCost, List<ActionEnerPay.PaidEnerData> listPaidEnerData) {
        this.isOwnCard = CardIndex.isOwnCard(cardIndex);
        this.imageSet = cardIndex.getImageSet();
        this.cardName = cardIndex.getCardReference().getName();
        if (sourceAbility != null) {
            this.abilityDescription = DescriptionParser.getAbilityDescription(sourceAbility);
        }
        if (sourceCost != null) {
            this.hasCost = true;
            this.isGuard = Game.getCurrentGame().getGameRules().isGuardStep();
        }
        for (ActionEnerPay.PaidEnerData enerData : listPaidEnerData) {
            this.snapshotPaidEnerData.add((Pair<String, CardConst.CardColor>)new Pair((Object)enerData.cardIndexSnapshot().getSourceCardIndex().getImageSet(), (Object)enerData.cardColor()));
        }
    }

    @Override
    public LogEntry createNewLogEntry() {
        LogEntryCard entry = new LogEntryCard(this.isOwnCard, this.imageSet, this.cardName, false, null, false, this.abilityDescription, false, this.hasCost, this.isGuard, LanguageParser.getString("UI_GAME_LOG_CARD_PAY_ENER"), LogEntryCard.ArrowsDirection.NONE);
        FlowPane content = new FlowPane();
        content.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        content.setAlignment(Pos.CENTER);
        content.setHgap(5.0);
        content.setVgap(5.0);
        for (Pair<String, CardConst.CardColor> enerData : this.snapshotPaidEnerData) {
            VBox container = new VBox();
            container.setAlignment(Pos.CENTER);
            container.setSpacing(2.0);
            ImageView imageEner = new ImageView(ImageCache.INSTANCE.getImageIcon(ImageCache.getColorIconPath((CardConst.CardColor)((Object)enerData.getValue()))));
            Text textArrow = new Text("\u2b07");
            textArrow.setFont(Font.font((String)"file:fonts/Symbola-12.ttf", (double)12.0));
            textArrow.setFill((Paint)Color.WHITE);
            ImageView imageCard = LogEntry.createCardImage((String)enerData.getKey());
            imageCard.setFitWidth(21.0);
            imageCard.setFitHeight(29.0);
            this.listCardImages.add(imageCard);
            container.getChildren().addAll((Object[])new Node[]{imageEner, textArrow, imageCard});
            content.getChildren().add((Object)container);
        }
        entry.getCustomContent().getChildren().add((Object)content);
        return entry;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.listCardImages.forEach(image -> {
            image.setImage(null);
            image.setOnMouseEntered(null);
        });
    }
}

