/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log.events;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.events.EventTarget;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.game.overlay.log.LogEntryTarget;
import open.batoru.game.overlay.log.events.LogEvent;

public class LogEventTarget
extends LogEvent {
    private final Game.GamePlayerRole sourceTargetRole;
    private final boolean isTargetOwnCard;
    private final String targetImageSet;
    private final String targetCardName;
    private final GameConst.CardLocation targetLocation;
    private Boolean isSourceOwnCard;

    public LogEventTarget(EventTarget event) {
        this(event.getCallerCardIndex(), event.getSourceCardIndex(), event.getSourceTargetRole());
    }

    public LogEventTarget(CardIndex target, CardIndex source, Game.GamePlayerRole sourceTargetRole) {
        this.sourceTargetRole = sourceTargetRole;
        this.isTargetOwnCard = CardIndex.isOwnCard(target);
        this.targetImageSet = target.getImageSet();
        this.targetCardName = target.getCardReference().getName();
        this.targetLocation = target.getLocation();
        if (source != null) {
            this.isSourceOwnCard = CardIndex.isOwnCard(source);
        }
    }

    @Override
    public LogEntry createNewLogEntry() {
        return new LogEntryTarget(this.isTargetOwnCard, this.targetImageSet, this.targetCardName, this.targetLocation, this.isSourceOwnCard, this.sourceTargetRole);
    }
}

