/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import open.batoru.ImageCache;
import open.batoru.catalog.CardSorter;
import open.batoru.catalog.Catalog;
import open.batoru.catalog.SearchFilter;
import open.batoru.core.Disposable;
import open.batoru.data.Card;
import open.batoru.data.CardLoader;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.ui.UI;
import open.batoru.ui.UIConst;
import open.batoru.ui.UtilDispose;

public class OverlayWindowCardCatalog
extends OverlayWindow
implements Catalog {
    private final ListView<Card> listView = new ListView();
    private final Set<String> pickedCards = new HashSet<String>();
    private final int minPicks;
    private final HBox content;
    private final TextField fieldSearch;
    private List<Card> sortingList;
    private SearchFilter filter;
    private boolean isLocked;
    private String imageSetBias = "";
    private String originalDescription;
    private ChangeListener<String> listenerSearchText;
    private boolean isDisposed;

    public OverlayWindowCardCatalog(String title, String description, int minPicks) {
        super(title, description + (String)(minPicks == 1 ? "" : "\n0 / " + minPicks));
        if (minPicks > 1) {
            this.originalDescription = description;
        }
        this.minPicks = minPicks;
        this.fieldSearch = new TextField();
        this.fieldSearch.setMaxWidth(300.0);
        this.fieldSearch.setPromptText("Search...");
        this.listenerSearchText = (ov, oldValue, newValue) -> this.filter.search((String)newValue);
        this.fieldSearch.textProperty().addListener(this.listenerSearchText);
        this.getContentNode().getChildren().add((Object)this.fieldSearch);
        this.content = new HBox();
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.content);
        this.listView.setStyle("-fx-background-color: black;");
        this.listView.setOrientation(Orientation.HORIZONTAL);
        this.listView.setPrefHeight(115.0);
        this.listView.setFocusTraversable(false);
        this.listView.setSelectionModel(null);
        this.listView.setCellFactory(listView -> new ListCell<Card>(){
            private final CatalogEntry entry;
            {
                this.setStyle("-fx-background-color: black;");
                this.setPadding(Insets.EMPTY);
                this.setFocusTraversable(false);
                this.entry = OverlayWindowCardCatalog.this.createNewCatalogEntry();
            }

            public void updateItem(Card item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setGraphic(null);
                    if (OverlayWindowCardCatalog.this.isDisposed) {
                        this.entry.dispose();
                    }
                } else {
                    this.setGraphic((Node)this.entry);
                    this.entry.setCard(item);
                }
            }
        });
        this.getConfirmButton().setDisable(true);
        this.getContentNode().getChildren().add(this.listView);
    }

    public void setSearchFilter(SearchFilter filter) {
        this.filter = filter;
    }

    public SearchFilter getSearchFilter() {
        return this.filter;
    }

    protected CatalogEntry createNewCatalogEntry() {
        return new CatalogEntry();
    }

    @Override
    public void resetSortingList() {
        this.sortingList = new ArrayList<Card>(CardLoader.getDataCardObjects());
        if (this.imageSetBias.isEmpty()) {
            CardSorter.sortByUniqueRandom(this.sortingList);
        } else {
            CardSorter.sortByImageSet(this.imageSetBias, this.sortingList);
        }
        this.listView.getItems().setAll(this.sortingList);
    }

    @Override
    public void updateSortingList(List<Card> newList) {
        this.sortingList = newList;
        if (this.imageSetBias.isEmpty()) {
            CardSorter.sortByName(this.sortingList);
        } else {
            CardSorter.sortByImageSet(this.imageSetBias, this.sortingList);
        }
        this.listView.getItems().setAll(this.sortingList);
    }

    @Override
    public void resetCatalogScroll() {
        this.listView.scrollTo(0);
    }

    @Override
    public void updateCardsCountMessage(int count) {
    }

    @Override
    public List<Card> getSortingList() {
        return this.sortingList;
    }

    @Override
    public void setImageSetBias(String imageSetPrefix) {
        this.imageSetBias = imageSetPrefix;
    }

    public void setLock(boolean lock) {
        this.isLocked = lock;
        this.fieldSearch.setDisable(lock);
    }

    public Set<String> getPickedCards() {
        return this.pickedCards;
    }

    @Override
    public void forceFakeChoice(List<String> choices) {
        this.pickedCards.addAll(choices);
        this.getConfirmButton().setDisable(false);
        super.forceFakeChoice(choices);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.isDisposed = true;
        this.listView.getItems().clear();
        this.fieldSearch.textProperty().removeListener(this.listenerSearchText);
        this.listenerSearchText = null;
        this.content.getChildren().clear();
        UtilDispose.TEMP.detachChildDisposeListener((Node)this.content);
    }

    protected class CatalogEntry
    extends StackPane
    implements Disposable {
        private Card cardObject;
        private String imageSet;
        private final ImageView imageCard = new ImageView();

        public CatalogEntry() {
            this.setPadding(new Insets(5.0));
            this.imageCard.setFitWidth(63.0);
            this.imageCard.setFitHeight(87.0);
            Rectangle clip = new Rectangle(63.0, 87.0);
            clip.setArcWidth(9.0);
            clip.setArcHeight(9.0);
            this.imageCard.setClip((Node)clip);
            this.installMouseEvents();
            this.getChildren().add((Object)this.imageCard);
        }

        protected final void installMouseEvents() {
            this.setOnMouseEntered(e -> {
                if (OverlayWindowCardCatalog.this.isLocked || OverlayWindowCardCatalog.this.pickedCards.contains(this.imageSet)) {
                    return;
                }
                UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.imageSet);
                this.setBackground(UIConst.Style.BACKGROUND_HOVER);
            });
            this.setOnMouseExited(e -> {
                if (OverlayWindowCardCatalog.this.isLocked || OverlayWindowCardCatalog.this.pickedCards.contains(this.imageSet)) {
                    return;
                }
                this.setBackground(UIConst.Style.BACKGROUND_BLACK);
            });
            this.setOnMouseClicked(e -> {
                if (OverlayWindowCardCatalog.this.isLocked) {
                    return;
                }
                if (!OverlayWindowCardCatalog.this.pickedCards.contains(this.imageSet)) {
                    OverlayWindowCardCatalog.this.pickedCards.add(this.imageSet);
                    this.setBackground(UIConst.Style.BACKGROUND_MID);
                } else {
                    OverlayWindowCardCatalog.this.pickedCards.remove(this.imageSet);
                    this.setBackground(UIConst.Style.BACKGROUND_HOVER);
                }
                if (OverlayWindowCardCatalog.this.minPicks > 1) {
                    OverlayWindowCardCatalog.this.updateDescriptionText(OverlayWindowCardCatalog.this.originalDescription + "\n" + OverlayWindowCardCatalog.this.pickedCards.size() + " / " + OverlayWindowCardCatalog.this.minPicks);
                }
                OverlayWindowCardCatalog.this.getConfirmButton().setDisable(OverlayWindowCardCatalog.this.pickedCards.size() != OverlayWindowCardCatalog.this.minPicks);
            });
        }

        public void setCard(Card cardObject) {
            if (this.cardObject == cardObject) {
                return;
            }
            this.cardObject = cardObject;
            this.imageSet = cardObject.getImageSets().getPrimaryImageSet();
            this.imageCard.setImage(ImageCache.INSTANCE.getCardImage(this.imageSet));
            this.setBackground(OverlayWindowCardCatalog.this.pickedCards.contains(this.imageSet) ? UIConst.Style.BACKGROUND_MID : UIConst.Style.BACKGROUND_BLACK);
        }

        protected Card getCardObject() {
            return this.cardObject;
        }

        protected String getImageSet() {
            return this.imageSet;
        }

        protected ImageView getCardImage() {
            return this.imageCard;
        }

        @Override
        public void dispose() {
            this.imageCard.setImage(null);
            this.setOnMouseEntered(null);
            this.setOnMouseExited(null);
            this.setOnMouseClicked(null);
        }
    }
}

