/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import javafx.scene.image.ImageView;
import open.batoru.ImageCache;
import open.batoru.data.Card;
import open.batoru.game.overlay.window.OverlayWindowCardCatalog;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class OverlayWindowCardCatalogBond
extends OverlayWindowCardCatalog {
    public OverlayWindowCardCatalogBond() {
        super(LanguageParser.getString("UI_GAME_WINDOW_BOND_TITLE"), "", 1);
    }

    @Override
    protected OverlayWindowCardCatalog.CatalogEntry createNewCatalogEntry() {
        return new BondCatalogEntry(this);
    }

    protected class BondCatalogEntry
    extends OverlayWindowCardCatalog.CatalogEntry {
        private final ImageView iconBond = new ImageView(ImageCache.INSTANCE.getImageIcon("bond"));

        public BondCatalogEntry(OverlayWindowCardCatalogBond this$0) {
            super(this$0);
            this.iconBond.setFitWidth(36.0);
            this.iconBond.setPreserveRatio(true);
            this.iconBond.setVisible(false);
            this.getChildren().add((Object)this.iconBond);
        }

        @Override
        public void setCard(Card cardObject) {
            if (this.getCardObject() == cardObject) {
                return;
            }
            super.setCard(cardObject);
            if (UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getData().hasStudentBond(this.getImageSet())) {
                this.setOnMouseEntered(null);
                this.setOnMouseExited(null);
                this.setOnMouseClicked(null);
                this.getCardImage().setOnMouseEntered(e -> UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.getImageSet()));
                this.getCardImage().setOpacity(0.75);
                this.iconBond.setVisible(true);
            } else {
                if (this.getOnMouseEntered() == null) {
                    this.installMouseEvents();
                }
                this.getCardImage().setOnMouseEntered(null);
                this.getCardImage().setOpacity(1.0);
                this.iconBond.setVisible(false);
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            this.getCardImage().setOnMouseEntered(null);
        }
    }
}

