/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.util.List;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.ability.Ability;
import open.batoru.game.overlay.window.OverlayWindowChoice;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UIConst;

public class OverlayWindowChoiceByRef
extends OverlayWindowChoice {
    private final ImageView imageCardSourceAbilityRef;
    private final ImageView imageCard;
    private final ImageView imageCardSourceAbility;

    public OverlayWindowChoiceByRef(String titleRefType, CardIndex cardIndex, Ability sourceAbility, Ability[] listSourceAbilityRef, List<String> listOptions) {
        super(titleRefType + " " + LanguageParser.getString("UI_GAME_WINDOW_REF_TITLE"), LanguageParser.getString("UI_GAME_WINDOW_REF_DESC") + titleRefType.toLowerCase(), sourceAbility, listOptions);
        HBox container = new HBox();
        container.setAlignment(Pos.CENTER);
        container.setSpacing(10.0);
        StackPane containerAbilityRef = new StackPane();
        containerAbilityRef.setMinWidth(87.0);
        this.imageCardSourceAbilityRef = OverlayWindowChoiceByRef.createCardImage(listSourceAbilityRef[0].getSourceCardIndex());
        containerAbilityRef.getChildren().add((Object)this.imageCardSourceAbilityRef);
        StackPane containerCardIndex = new StackPane();
        containerCardIndex.setBackground(UIConst.Style.BACKGROUND_RED_DEEP);
        containerCardIndex.setPadding(new Insets(1.0));
        Rectangle clip = new Rectangle(65.0, 89.0);
        clip.setArcWidth(9.0);
        clip.setArcHeight(9.0);
        containerCardIndex.setClip((Node)clip);
        this.imageCard = OverlayWindowChoiceByRef.createCardImage(cardIndex);
        containerCardIndex.getChildren().add((Object)this.imageCard);
        this.imageCardSourceAbility = OverlayWindowChoiceByRef.createCardImage(sourceAbility.getSourceCardIndex());
        container.getChildren().addAll((Object[])new Node[]{containerAbilityRef, OverlayWindowChoiceByRef.createHeaderText("\u25b6", 12, Color.KHAKI), this.imageCardSourceAbility, OverlayWindowChoiceByRef.createHeaderText("\u2938", 48, Color.RED), containerCardIndex});
        VBox.setMargin((Node)container, (Insets)new Insets(0.0, 0.0, 0.0, -127.0));
        this.getContentNode().getChildren().add((Object)container);
        for (String option : listOptions) {
            Button button = OverlayWindowChoiceByRef.createButton(option);
            this.getButtonsList().add(button);
            this.addWindowButton(button);
        }
        this.hideConfirmButton();
    }

    public static Text createHeaderText(String string, int size, Color color) {
        Text text = new Text(string);
        text.setFont(Font.font((String)"DejaVu", (FontWeight)FontWeight.BOLD, (double)size));
        text.setFill((Paint)color);
        return text;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.imageCardSourceAbilityRef.setOnMouseEntered(null);
        this.imageCard.setOnMouseEntered(null);
        this.imageCardSourceAbility.setOnMouseEntered(null);
    }
}

