/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.web.WebView;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.data.ability.Ability;
import open.batoru.game.FieldZone;
import open.batoru.game.Zone;
import open.batoru.game.overlay.window.OverlayWindowChoiceEffect;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.UIConst;
import open.batoru.ui.UtilDispose;

public class OverlayWindowEffectUseOverride
extends OverlayWindowChoiceEffect {
    public OverlayWindowEffectUseOverride(List<Ability> listAbilities, boolean allowSkip) {
        super(LanguageParser.getString("UI_GAME_WINDOW_OVERRIDE_TITLE"), LanguageParser.getString("UI_GAME_WINDOW_OVERRIDE_DESC"));
        for (int i = 0; i < listAbilities.size(); ++i) {
            this.addAbility(i, listAbilities.get(i));
        }
        if (!allowSkip) {
            this.hideConfirmButton();
        } else {
            this.getConfirmButton().setText(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_SKIP"));
            this.getConfirmButton().setOnAction(e -> {
                if (this.isLocked() || this.getOnAbilityChosenHandler() == null) {
                    return;
                }
                this.getOnAbilityChosenHandler().handle(-1);
                this.setLock(true);
            });
        }
    }

    private void addAbility(int arrayId, Ability ability) {
        HBox container = new HBox();
        container.setAlignment(Pos.CENTER);
        container.setSpacing(10.0);
        WebView descriptionWebView = new WebView();
        descriptionWebView.setContextMenuEnabled(false);
        descriptionWebView.getEngine().setJavaScriptEnabled(false);
        descriptionWebView.setMaxSize(400.0, 80.0);
        descriptionWebView.getEngine().loadContent(DescriptionParser.DEFAULT.parseDescription(DescriptionParser.getActionReplacementAbilityDescription(ability.getCachedAbilityDescription())));
        ImageView imageCard = OverlayWindowEffectUseOverride.createCardImage(ability.getSourceCardIndex());
        container.getChildren().addAll((Object[])new Node[]{imageCard, descriptionWebView});
        container.setOnMouseEntered(e -> {
            if (this.isLocked()) {
                return;
            }
            container.setBackground(UIConst.Style.BACKGROUND_HOVER);
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(ability.getSourceCardIndex());
            Zone patt0$temp = ability.getSourceCardIndex().getZoneByLocation();
            if (patt0$temp instanceof FieldZone) {
                FieldZone fieldZone = (FieldZone)patt0$temp;
                fieldZone.installZoneHighlighter();
            }
        });
        container.setOnMouseExited(e -> {
            if (this.isLocked()) {
                return;
            }
            container.setBackground(UIConst.Style.BACKGROUND_TRANSPARENT);
        });
        container.setOnMouseClicked(e -> {
            if (this.isLocked() || this.getOnAbilityChosenHandler() == null) {
                return;
            }
            this.getOnAbilityChosenHandler().handle(arrayId);
            this.setLock(true);
        });
        UtilDispose.TEMP.setOnDisposed((Node)container, () -> {
            container.setOnMouseEntered(null);
            container.setOnMouseExited(null);
            container.setOnMouseClicked(null);
            imageCard.setOnMouseEntered(null);
            imageCard.setImage(null);
        });
        this.getContentNode().getChildren().add((Object)container);
    }

    @Override
    public void dispose() {
        super.dispose();
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.getContentNode());
        this.getContentNode().getChildren().clear();
        UtilDispose.TEMP.detachChildDisposeListener((Node)this.getContentNode());
    }
}

