/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.networking.HTTPPostRequest;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class OverlayWindowReport
extends OverlayWindow {
    private static final int MAX_MESSAGE_LENGTH = 500;
    private static final int MAX_LOG_LENGTH = 2048;
    private final TextArea textArea = new TextArea();

    public OverlayWindowReport() {
        super(LanguageParser.getString("UI_GAME_REPORT_BUTTON"), "", "border3", "border3");
        this.setMaxHeight(250.0);
        this.textArea.setPromptText(LanguageParser.getString("UI_GAME_REPORT_MESSAGE_HINT"));
        VBox.setMargin((Node)this.textArea, (Insets)new Insets(0.0, 20.0, 0.0, 20.0));
        this.getContentNode().getChildren().add((Object)this.textArea);
        this.getConfirmButton().setText(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_SEND"));
        this.getConfirmButton().setOnAction(e -> {
            String log;
            if (this.textArea.getLength() == 0) {
                UI.getTabGame().getFieldSceneOverlay().toggleReportWindow();
                return;
            }
            String message = this.textArea.getText(0, Math.min(500, this.textArea.getLength()));
            List<String> lastLogMessages = Log.readLastMessages(15);
            if (lastLogMessages != null) {
                log = String.join((CharSequence)"\n", lastLogMessages);
                if (log.length() > 2048) {
                    log = log.substring(0, 2048);
                }
            } else {
                log = "";
            }
            String data = "gameId=" + Game.getCurrentGame().getGameId() + "&username=" + URLEncoder.encode(Player.getUsername(), StandardCharsets.UTF_8) + "&message=" + URLEncoder.encode(message, StandardCharsets.UTF_8) + "&log=" + URLEncoder.encode(log, StandardCharsets.UTF_8);
            this.getConfirmButton().setDisable(true);
            new Thread(() -> {
                HTTPPostRequest request = new HTTPPostRequest();
                try {
                    Properties props = request.send("https://open.batoru.moe/game/service/report.php", data);
                    String responseCode = props.getProperty("response");
                    Platform.runLater(() -> {
                        if (responseCode == null || !responseCode.equals("!1")) {
                            new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_REPORT_FAIL") + "\n\nResponse code: " + responseCode, new ButtonType[0]).show();
                            return;
                        }
                        new Alert(Alert.AlertType.INFORMATION, LanguageParser.getString("UI_ALERT_REPORT_SUCCESS"), new ButtonType[0]).show();
                        this.textArea.clear();
                        UI.getTabGame().getFieldSceneOverlay().toggleReportWindow();
                    });
                }
                catch (IOException | InterruptedException ex) {
                    Platform.runLater(() -> new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_REPORT_FAIL"), new ButtonType[0]).show());
                }
                finally {
                    Platform.runLater(() -> this.getConfirmButton().setDisable(false));
                }
            }).start();
        });
    }
}

