/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.ImageCache;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.game.FieldData;
import open.batoru.game.overlay.window.OverlayWindowCardList;
import open.batoru.parsers.LanguageParser;

public class OverlayWindowViewDeck
extends OverlayWindowCardList {
    public OverlayWindowViewDeck(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location) {
        super(LanguageParser.getString("UI_GAME_WINDOW_VIEW_TITLE") + (rolePlayer == Game.getCurrentGame().getPlayerRole() ? "" : LanguageParser.getString("UI_GAME_WINDOW_SEARCH_TITLE_OP")) + (location == GameConst.CardLocation.DECK_LRIG || location == GameConst.CardLocation.TRASH_LRIG ? LanguageParser.getString("UI_GAME_WINDOW_VIEW_TITLE_LRIG") : "") + (location == GameConst.CardLocation.TRASH || location == GameConst.CardLocation.TRASH_LRIG ? TargetFilter.TargetHint.TRASH.getActionDescription() : LanguageParser.getString("UI_GAME_WINDOW_SEARCH_TITLE_DECK")), null, FieldData.getZoneByLocation(rolePlayer, location).getZoneCardList());
        if (location != GameConst.CardLocation.DECK_LRIG && location != GameConst.CardLocation.TRASH_LRIG) {
            this.enableCardSorting();
        }
        if (location == GameConst.CardLocation.TRASH) {
            ImageView imageLB = new ImageView(ImageCache.INSTANCE.getImageIcon("lifeburst"));
            Text textLBCount = OverlayWindowViewDeck.createText();
            textLBCount.setFill((Paint)Color.KHAKI);
            textLBCount.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
            textLBCount.setText(String.valueOf(this.getCardList().stream().filter(card3D -> card3D.getCardIndex().getCardReference().hasLifeBurst()).count()));
            Text textTotalCount = OverlayWindowViewDeck.createText();
            textTotalCount.setText("/ " + this.getCardList().size());
            textTotalCount.setFont(textLBCount.getFont());
            this.getContentInfoNode().getChildren().addFirst((Object)imageLB);
            this.getContentInfoNode().getChildren().add(1, (Object)textLBCount);
            this.getContentInfoNode().getChildren().add(2, (Object)textTotalCount);
            HBox.setMargin((Node)textTotalCount, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        }
    }
}

