/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking;

import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import open.batoru.Log;
import open.batoru.Main;
import open.batoru.core.Game;
import open.batoru.core.gameplay.actions.ActionAttackPre;
import open.batoru.core.gameplay.actions.ActionEffectActivateAction;
import open.batoru.core.gameplay.actions.ActionEffectEndCutInResponse;
import open.batoru.core.gameplay.actions.ActionGameEnd;
import open.batoru.core.gameplay.actions.ActionGrow;
import open.batoru.core.gameplay.actions.ActionPhaseAdvanceEnd;
import open.batoru.core.gameplay.actions.ActionPutOnFieldSIGNIPre;
import open.batoru.core.gameplay.actions.ActionPutOnFieldSpell;
import open.batoru.core.gameplay.actions.ActionRetire;
import open.batoru.core.gameplay.actions.ActionUseCardFromLRIGDeck;
import open.batoru.networking.NetworkReceiver;
import open.batoru.networking.PacketParser;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.ConnectionAttempt;
import open.batoru.networking.connection.GameSendReceivedResponseConfirmAttempt;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class GameReceiver
extends NetworkReceiver {
    private final Map<String, GamePacketProcessor> tokenProcessors = new HashMap<String, GamePacketProcessor>();

    public GameReceiver(DatagramSocket socket, int portOffset) {
        super(socket, 42007 + portOffset);
        this.initTokenProcessors();
    }

    @Override
    public void setPacketRedirectByToken(String token, ConnectionAttempt attempt, RedirectedReceiver.RedirectValidator validator, RedirectedReceiver.RedirectHandler handler) {
        super.setPacketRedirectByToken(token, attempt, validator, handler);
        FX.run(() -> UI.getTabGame().getFieldSceneOverlay().getGameControls().setWaitingServerRequest(true));
    }

    @Override
    public void stopPacketRedirectByToken(String token) {
        super.stopPacketRedirectByToken(token);
        FX.run(() -> UI.getTabGame().getFieldSceneOverlay().getGameControls().setWaitingServerRequest(false));
    }

    private void initTokenProcessors() {
        this.tokenProcessors.put("PASS", this::processPhaseAdvance);
        this.tokenProcessors.put("ENDCUT", this::processEndCutInResponse);
        this.tokenProcessors.put("GROW", this::processGrow);
        this.tokenProcessors.put("RET", this::processRetire);
        this.tokenProcessors.put("SIGNI", this::processSIGNI);
        this.tokenProcessors.put("SPELL", this::processSpell);
        this.tokenProcessors.put("ACTLRIG", this::processActionFromLRIGDeck);
        this.tokenProcessors.put("ACT", this::processActionAbility);
        this.tokenProcessors.put("ATK", this::processAttack);
        this.tokenProcessors.put("DC", this::processOPDisconnect);
        this.tokenProcessors.put("RC", this::processOPReconnect);
        this.tokenProcessors.put("GG", this::processOPSurrender);
    }

    final Map<String, GamePacketProcessor> getTokenProcessors() {
        return this.tokenProcessors;
    }

    @Override
    protected void processPacket(PacketParser pp) {
        int orderId;
        if (pp.getDataArgsNum() < 1) {
            return;
        }
        if (pp.getPacketDataToken().equals("0X")) {
            this.onProcessHeartbeat(pp);
            return;
        }
        Log.printMessage(">>> RECEIVED: " + pp.getPacketDataToken());
        GamePacketProcessor processor = this.tokenProcessors.get(pp.getPacketDataToken());
        if (processor != null && processor.process(orderId = Integer.parseInt(pp.getDataArgument(0)), pp)) {
            this.sendReceivedResponseConfirmation(orderId);
        }
    }

    private void sendReceivedResponseConfirmation(int orderId) {
        try {
            GameSendReceivedResponseConfirmAttempt attempt = new GameSendReceivedResponseConfirmAttempt(orderId);
            attempt.send();
        }
        catch (SocketException | UnknownHostException ex) {
            Log.printMessage(ex);
        }
    }

    private boolean processPhaseAdvance(int orderId, PacketParser pp) {
        Game.getCurrentGame().getActionQueue().addServerAction(orderId, new ActionPhaseAdvanceEnd());
        return true;
    }

    private boolean processEndCutInResponse(int orderId, PacketParser pp) {
        Game.getCurrentGame().getActionQueue().addServerAction(orderId, new ActionEffectEndCutInResponse());
        return true;
    }

    private boolean processGrow(int orderId, PacketParser pp) {
        if (pp.getDataArgsNum() < 2) {
            if (Game.getCurrentGame().getFakeReceiver() != null) {
                Game.getCurrentGame().getActionQueue().addEmptyServerAction(orderId, "ActionGrow");
                Game.getCurrentGame().getFakeReceiver().processIdle(orderId + 1);
            }
            return false;
        }
        if (pp.getDataArgument(1).isEmpty() || pp.getDataArgument(1).equals(String.valueOf(0))) {
            Game.getCurrentGame().getActionQueue().addEmptyServerAction(orderId, "ActionGrow");
            return true;
        }
        Game.getCurrentGame().getActionQueue().addServerAction(orderId, new ActionGrow(pp));
        return true;
    }

    private boolean processRetire(int orderId, PacketParser pp) {
        Game.getCurrentGame().getActionQueue().addServerAction(orderId, new ActionRetire(pp));
        return true;
    }

    private boolean processSIGNI(int orderId, PacketParser pp) {
        if (pp.getDataArgsNum() < 3) {
            return false;
        }
        Game.getCurrentGame().getActionQueue().addServerAction(orderId, new ActionPutOnFieldSIGNIPre(pp));
        return true;
    }

    private boolean processSpell(int orderId, PacketParser pp) {
        if (pp.getDataArgsNum() < 2) {
            return false;
        }
        Game.getCurrentGame().getActionQueue().addServerAction(orderId, new ActionPutOnFieldSpell(pp));
        return true;
    }

    private boolean processActionFromLRIGDeck(int orderId, PacketParser pp) {
        if (pp.getDataArgsNum() < 2) {
            return false;
        }
        Game.getCurrentGame().getActionQueue().addServerAction(orderId, new ActionUseCardFromLRIGDeck(pp));
        return true;
    }

    private boolean processActionAbility(int orderId, PacketParser pp) {
        if (pp.getDataArgsNum() < 3) {
            return false;
        }
        Game.getCurrentGame().getActionQueue().addServerAction(orderId, new ActionEffectActivateAction(pp));
        return true;
    }

    private boolean processAttack(int orderId, PacketParser pp) {
        if (pp.getDataArgsNum() < 2) {
            return false;
        }
        Game.getCurrentGame().getActionQueue().addServerAction(orderId, new ActionAttackPre(pp));
        return true;
    }

    private boolean processOPDisconnect(int orderId, PacketParser pp) {
        Platform.runLater(() -> {
            if (UI.getTabGame().getFieldSceneOverlay().getWinScreen() == null && !UI.getTabGame().getFieldSceneOverlay().getGameControls().getButtonSurrender().isDisabled()) {
                UI.getTabGame().getFieldSceneOverlay().showDisconnectedScreen();
            }
        });
        return true;
    }

    private boolean processOPReconnect(int orderId, PacketParser pp) {
        Platform.runLater(() -> UI.getTabGame().getFieldSceneOverlay().hideDisconnectedScreen());
        return true;
    }

    private boolean processOPSurrender(int orderId, PacketParser pp) {
        if (pp.getDataArgsNum() < 2) {
            return false;
        }
        Platform.runLater(() -> {
            String message;
            if (Game.getCurrentGame().getGameState() != Game.GameState.IN_PROGRESS) {
                return;
            }
            UI.getTabGame().getFieldSceneOverlay().hideDisconnectedScreen();
            UI.getTabGame().getFieldSceneOverlay().showBlackScreen(false);
            UI.getTabGame().getFieldSceneOverlay().showGameMessage(null);
            switch (pp.getDataArgsNum() == 2 ? "1" : pp.getDataArgument(2)) {
                case "1": {
                    String string = LanguageParser.getString("UI_GAME_WINSCREEN_WIN");
                    break;
                }
                case "0": {
                    String string = LanguageParser.getString("UI_GAME_WINSCREEN_LOSE");
                    break;
                }
                default: {
                    String string = message = LanguageParser.getString("UI_GAME_WINSCREEN_NONE");
                }
            }
            String subtitle = pp.getDataArgsNum() == 2 ? LanguageParser.getString("UI_GAME_WINSCREEN_SUBTITLE_SURRENDER") : (!pp.getDataArgument(2).equals("-1") ? LanguageParser.getString("UI_GAME_WINSCREEN_SUBTITLE_SPEC_SURRENDER") : LanguageParser.getString("UI_GAME_WINSCREEN_SUBTITLE_SPEC_NONE"));
            ActionGameEnd.executeGameEnd(message, subtitle);
            String checksum = Game.getCurrentGame().getSourceReplayChecksum() == null ? pp.getDataArgument(1) : Game.getCurrentGame().getSourceReplayChecksum();
            UI.getTabGame().getFieldSceneOverlay().getWinScreen().receiveReplayData(checksum);
        });
        return true;
    }

    private void onProcessHeartbeat(PacketParser pp) {
        long ping = System.currentTimeMillis() - Long.parseLong(pp.getDataArgument(0));
        Platform.runLater(() -> Main.updateWindowTitle("~" + ping + "ms"));
    }

    @FunctionalInterface
    public static interface GamePacketProcessor {
        public boolean process(int var1, PacketParser var2);
    }
}

