/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking;

import java.net.SocketException;
import java.net.UnknownHostException;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.data.ability.CardAbilities;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.networking.connection.LogoutAttempt;
import open.batoru.ui.UI;

public class LogoutProcedure {
    public static void execute() {
        if (Player.getUsername() != null && Player.getKeyHash() != null) {
            try {
                LogoutAttempt attempt = new LogoutAttempt(42001);
                attempt.send();
            }
            catch (SocketException | UnknownHostException ex) {
                System.err.println(ex.getMessage());
            }
            LogoutProcedure.disconnectGame();
        }
        if (Game.getCurrentGame() != null) {
            UI.getTabGame().getFieldSceneOverlay().getGameControls().stopGameDurationTimer();
            UI.getTabGame().getFieldSceneOverlay().hideDisconnectedScreen();
        }
        if (Player.getNetworkFrame() != null) {
            Player.getNetworkFrame().stopAll();
        }
        if (AbilityCost.getCallbackAction() != null) {
            AbilityCost.getCallbackAction().getCallbackThread().interrupt();
        }
        if (CardAbilities.getEffectCallbackAction() != null) {
            CardAbilities.getEffectCallbackAction().getCallbackThread().interrupt();
        }
    }

    public static void disconnectGame() {
        if (Game.getCurrentGame() == null || Game.getCurrentGame().getGameServerPortOffset() == 0) {
            return;
        }
        try {
            LogoutAttempt attempt = new LogoutAttempt(Game.getCurrentGame().getGameServerPort());
            attempt.send();
        }
        catch (SocketException | UnknownHostException ex) {
            System.err.println(ex.getMessage());
        }
    }
}

