/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking;

import open.batoru.core.Game;
import open.batoru.networking.GameReceiver;
import open.batoru.networking.RoomsReceiver;

public class NetworkFrame {
    private RoomsReceiver roomsReceiver;
    private GameReceiver gameReceiver;

    public void startGameReceiver(GameReceiver receiver) {
        if (this.gameReceiver != null) {
            this.gameReceiver.end();
        }
        this.gameReceiver = receiver;
        receiver.start();
    }

    public void startRoomsReceiver(RoomsReceiver receiver) {
        if (this.roomsReceiver != null) {
            this.roomsReceiver.end();
        }
        this.roomsReceiver = receiver;
        receiver.start();
    }

    public void stopAll() {
        if (Game.getCurrentGame() != null) {
            Game.getCurrentGame().setGameState(Game.GameState.POST_GAME);
            Game.getCurrentGame().getActionQueue().stop();
        }
        if (this.roomsReceiver != null) {
            this.roomsReceiver.end();
        }
        if (this.gameReceiver != null) {
            this.gameReceiver.end();
        }
    }

    public RoomsReceiver getRoomsReceiver() {
        return this.roomsReceiver;
    }

    public GameReceiver getGameReceiver() {
        return this.gameReceiver;
    }
}

