/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import open.batoru.Log;
import open.batoru.Settings;
import open.batoru.core.Game;
import open.batoru.networking.LogoutProcedure;
import open.batoru.networking.PacketParser;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.RoomsReceiver;
import open.batoru.networking.connection.ConnectionAttempt;
import open.batoru.networking.connection.HeartbeatAttempt;
import open.batoru.networking.connection.STUNResolver;
import open.batoru.networking.service.GameReconnectService;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public abstract class NetworkReceiver
extends Thread {
    private final DatagramSocket socket;
    private final int sendPort;
    private final Map<String, RedirectedReceiver> redirectedTokens = new HashMap<String, RedirectedReceiver>();
    private STUNResolver stunResolver;
    private String publicAddress;
    private int publicPort;

    public NetworkReceiver(DatagramSocket socket, int sendPort) {
        super("net-receive-" + String.valueOf(socket != null ? Integer.valueOf(socket.getLocalPort()) : "fake"));
        if (socket != null) {
            System.out.println("-> " + socket.getLocalPort());
        }
        this.socket = socket;
        this.sendPort = sendPort;
    }

    @Override
    public void start() {
        super.start();
        if (this.socket != null) {
            this.stunResolver = new STUNResolver(this.socket);
            if (Settings.INSTANCE.isConnectNewDirect()) {
                this.stunResolver.setSendPort(this.sendPort);
            }
            try {
                this.socket.setSoTimeout(0);
                HeartbeatAttempt attempt = new HeartbeatAttempt(this);
                attempt.send();
            }
            catch (SocketException | UnknownHostException ex) {
                Log.printMessage(ex);
            }
        }
    }

    @Override
    public synchronized void run() {
        block4: while (true) {
            try {
                while (true) {
                    RedirectedReceiver redirectedReceiver;
                    PacketParser pp;
                    int tokenHeadEnd;
                    byte[] buffer = new byte[256];
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    if (this.socket == null) break block4;
                    this.socket.receive(packet);
                    String packetAddress = packet.getAddress().getHostAddress();
                    if (!packetAddress.equals("51.68.136.140")) continue;
                    if (this.stunResolver != null && STUNResolver.isStunResponse(buffer)) {
                        InetSocketAddress address = this.stunResolver.parseStunResponse(buffer);
                        if (address == null) continue;
                        this.publicAddress = address.getAddress().getHostAddress();
                        this.publicPort = address.getPort();
                        continue;
                    }
                    String packetContent = new String(buffer).trim();
                    if (!packetContent.startsWith("0")) {
                        if (!(this instanceof RoomsReceiver)) {
                            Log.printMessage("<<< " + packetContent);
                        } else {
                            System.out.println("<<< " + packetContent);
                        }
                    }
                    if ((tokenHeadEnd = packetContent.indexOf(36)) == -1 || !(pp = new PacketParser(packetContent)).isChecksumCorrect()) continue;
                    if (pp.getDataArgument(0).equals("!7")) {
                        Platform.runLater(() -> this.showDesyncAlert(pp));
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            Log.printMessage(true, "Warning: Interrupt attempt in NetworkReceiver thread.");
                        }
                        if (this.socket.isClosed()) {
                            return;
                        }
                    }
                    if ((redirectedReceiver = this.redirectedTokens.get(pp.getPacketDataToken())) == null) {
                        this.processPacket(pp);
                        continue;
                    }
                    if (!redirectedReceiver.isValidResponse(pp)) continue;
                    if (!redirectedReceiver.hasCustomValidator()) {
                        this.stopPacketRedirectByToken(pp.getPacketDataToken());
                        redirectedReceiver.setReceivedPacketAsSatisfying();
                        Platform.runLater(() -> redirectedReceiver.processResponse(pp));
                        continue;
                    }
                    redirectedReceiver.processResponse(pp);
                }
            }
            catch (IOException ex) {
                if (this.socket.isClosed()) break;
                System.err.println(ex.getMessage());
                continue;
            }
            break;
        }
    }

    private synchronized void releaseThread() {
        this.notify();
    }

    public final void setPacketRedirect(ConnectionAttempt attempt, RedirectedReceiver.RedirectValidator validator, RedirectedReceiver.RedirectHandler handler) {
        this.setPacketRedirectByToken(attempt.getToken() + "X", attempt, validator, handler);
    }

    public final void setCustomPacketRedirectByToken(String token, RedirectedReceiver.RedirectHandler handler) {
        this.setPacketRedirectByToken(token, null, RedirectedReceiver.RedirectValidator.CUSTOM, handler);
    }

    public void setPacketRedirectByToken(String token, ConnectionAttempt attempt, RedirectedReceiver.RedirectValidator validator, RedirectedReceiver.RedirectHandler handler) {
        this.redirectedTokens.put(token, new RedirectedReceiver(attempt, validator, handler));
    }

    public void stopPacketRedirectByToken(String token) {
        this.redirectedTokens.remove(token);
    }

    protected abstract void processPacket(PacketParser var1);

    public DatagramSocket getSocket() {
        return this.socket;
    }

    public int getSendPort() {
        return this.sendPort;
    }

    public STUNResolver getStunResolver() {
        return this.stunResolver;
    }

    public String getPublicAddress() {
        return this.publicAddress;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    public void end() {
        this.interrupt();
        if (this.socket != null) {
            this.socket.close();
        }
    }

    private void showDesyncAlert(PacketParser pp) {
        int orderId = Integer.parseInt(pp.getDataArgument(1));
        String serverAction = pp.getDataArgument(2);
        String clientAction = Game.getCurrentGame().getActionQueue().getActionClassName(orderId);
        Log.printMessage(true, "Warning: Desync detected (" + orderId + ") -> " + clientAction + " != " + serverAction);
        Alert alert = new Alert(Alert.AlertType.WARNING, LanguageParser.getString("UI_ALERT_DESYNC_EXPECTED") + " " + clientAction + "\n" + LanguageParser.getString("UI_ALERT_DESYNC_GOT") + " " + serverAction + "\n" + LanguageParser.getString("UI_ALERT_DESYNC_RECONNECT"), new ButtonType[]{ButtonType.YES, ButtonType.NO});
        alert.setHeaderText(LanguageParser.getString("UI_ALERT_DESYNC_HEADER"));
        alert.showAndWait().ifPresent(result -> {
            UI.getTabGame().getFieldSceneOverlay().getGameControls().setWaitingServerRequest(false);
            LogoutProcedure.disconnectGame();
            this.end();
            this.releaseThread();
            if (result.getButtonData() == ButtonBar.ButtonData.YES) {
                Platform.runLater(() -> {
                    GameReconnectService service = new GameReconnectService(Game.getCurrentGame().getGameServerPortOffset(), Game.getCurrentGame().getGameId());
                    UI.getTabGame().closeGame(false);
                    service.start();
                });
            } else {
                UI.getTabGame().getFieldSceneOverlay().showBlackScreen(true);
                UI.getTabGame().getFieldSceneOverlay().showGameMessage("   " + LanguageParser.getString("UI_GAME_MESSAGE_DISCONNECT_INTERRUPT"), false);
            }
        });
    }
}

