/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking;

import java.util.ArrayList;
import java.util.List;
import open.batoru.networking.UtilHash;

public class PacketParser {
    private final String packetContent;
    private String packetData;
    private String packetToken;
    private boolean isChecksumCorrect;
    private final List<String> dataArgsList = new ArrayList<String>();

    public PacketParser(String packetContent) {
        this.packetContent = packetContent;
        int tokenHeadEnd = packetContent.indexOf(36);
        if (tokenHeadEnd == -1) {
            return;
        }
        int tokenChecksumEnd = packetContent.indexOf(35);
        if (tokenChecksumEnd != -1) {
            String packetChecksum = packetContent.substring(tokenHeadEnd + 1, tokenChecksumEnd);
            this.packetData = packetContent.substring(tokenChecksumEnd + 1);
            this.isChecksumCorrect = packetChecksum.equals(UtilHash.generateChecksum(this.packetData));
        } else {
            this.packetData = packetContent.substring(tokenHeadEnd + 1);
        }
        this.packetToken = packetContent.substring(0, tokenHeadEnd);
        this.parseData();
    }

    private void parseData() {
        String[] splitData = this.packetData.split("\\|", -1);
        this.dataArgsList.addAll(List.of(splitData));
    }

    public int getDataArgsNum() {
        return this.dataArgsList.size();
    }

    public String getDataArgument(int index) {
        return index >= 0 && index < this.getDataArgsNum() ? this.dataArgsList.get(index) : null;
    }

    public String getPacketContent() {
        return this.packetContent;
    }

    public String getPacketDataToken() {
        return this.packetToken;
    }

    public String getPacketData() {
        return this.packetData;
    }

    public boolean isDataResponseCode() {
        return this.packetData.startsWith("!");
    }

    public boolean isChecksumCorrect() {
        return this.isChecksumCorrect;
    }
}

