/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking;

import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import open.batoru.Main;
import open.batoru.Settings;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.rooms.Room;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataImageSet;
import open.batoru.networking.GameReceiver;
import open.batoru.networking.NetworkReceiver;
import open.batoru.networking.PacketParser;
import open.batoru.networking.SpecFakeGameReceiver;
import open.batoru.networking.UsernameData;
import open.batoru.networking.connection.GameSendPlayerConnectAttempt;
import open.batoru.networking.connection.RoomGameSendDeckAttempt;
import open.batoru.networking.connection.RoomGuestGameAcceptAttempt;
import open.batoru.networking.connection.RoomQueryAttempt;
import open.batoru.networking.connection.RunnableConnection;
import open.batoru.networking.connection.TemporaryPacketRedirect;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.UserAttentionNotifier;
import open.batoru.ui.rooms.LiveGameEntry;
import open.batoru.ui.rooms.OpenRoomEntry;
import open.batoru.ui.rooms.RoomListEntry;

public class RoomsReceiver
extends NetworkReceiver {
    private final Map<String, RoomPacketProcessor> tokenProcessors = new HashMap<String, RoomPacketProcessor>();
    private RoomQueryAttempt query;
    private StringBuilder cacheChunkData;
    private int currentChunkId;
    private long lastUpdate;
    private boolean shouldSortLiveGames;

    public RoomsReceiver(DatagramSocket socket) {
        super(socket, 42005);
        this.initTokenProcessors();
    }

    public void startQuery() {
        if (this.query != null) {
            return;
        }
        this.stopQuery();
        UI.getTabRooms().setLock(true);
        try {
            this.query = new RoomQueryAttempt(this.getSocket(), this.lastUpdate);
            this.query.setOnRequestPreSend(() -> {
                if (this.getPublicAddress() == null || this.getPublicPort() == 0) {
                    return;
                }
                if (this.cacheChunkData == null && UI.getTabRooms().getRoomListLive().isLocked() && UI.getTabRooms().getRoomListLive().getTotalEntries() == 0 && UI.getTabRooms().getRoomListOpen().getTotalEntries() == 0) {
                    Platform.runLater(() -> UI.getTabRooms().setLock(false));
                }
                this.query.updateData(this.lastUpdate, Game.getCurrentGame() == null || !(Game.getCurrentGame().getFakeReceiver() instanceof SpecFakeGameReceiver) ? 0 : Game.getCurrentGame().getRoom().getRoomId());
            });
            this.query.send();
        }
        catch (UnknownHostException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public void stopQuery() {
        if (this.query != null) {
            this.query.setReceivedPacketAsSatisfying();
            this.query = null;
        }
    }

    @Override
    public void end() {
        this.stopQuery();
        super.end();
    }

    private void updateLastRecordId(int recordId) {
        System.out.println(">>> updated: " + recordId);
        this.lastUpdate = recordId;
    }

    private void initTokenProcessors() {
        this.tokenProcessors.put("QX", this::onProcessRoomQueryResponse);
        this.tokenProcessors.put("RS", this::onProcessRoomGameStart);
        this.tokenProcessors.put("0X", this::onProcessHeartbeat);
    }

    @Override
    protected void processPacket(PacketParser pp) {
        if (pp.getDataArgsNum() < 1) {
            return;
        }
        RoomPacketProcessor processor = this.tokenProcessors.get(pp.getPacketDataToken());
        if (processor == null || processor.process(pp)) {
            // empty if block
        }
    }

    private boolean onProcessHeartbeat(PacketParser pp) {
        long ping = System.currentTimeMillis() - Long.parseLong(pp.getDataArgument(0));
        int onlinePlayersCount = Integer.parseInt(pp.getDataArgument(1));
        Platform.runLater(() -> {
            Main.updateWindowTitle("~" + ping + "ms");
            UI.getTabRooms().getControls().updateOnlinePlayersCount(onlinePlayersCount);
        });
        return true;
    }

    private boolean onProcessRoomQueryResponse(PacketParser pp) {
        System.out.println(">>> QUERY: " + pp.getPacketData());
        return this.parseRoomQueryData(pp.getPacketData());
    }

    public boolean parseRoomQueryData(String data) {
        int i = 0;
        String[] splitData = data.split("\\|", -1);
        if (!splitData[0].startsWith("~")) {
            block28: while (i < splitData.length) {
                switch (splitData[i]) {
                    case "C": {
                        int roomId = Integer.parseInt(splitData[i + 1]);
                        String hostUsername = UsernameData.updateAndGet(splitData[i + 2]);
                        String description = splitData[i + 3];
                        int roomFlags = Integer.parseInt(splitData[i + 4]);
                        CardConst.PlayFormat playFormat = CardConst.PlayFormat.getPlayFormatById(Integer.parseInt(splitData[i + 5]));
                        Room.StartingPlayer startingPlayer = Room.StartingPlayer.getStartingPlayerById(Integer.parseInt(splitData[i + 6]));
                        Platform.runLater(() -> {
                            if (!UI.getTabRooms().getRoomListOpen().containsEntry(roomId)) {
                                UI.getTabRooms().getRoomListLive().removeEntry(roomId);
                                Room room = UI.getTabRooms().getRoomCoordinator().getRoomOrDefault(roomId, roomFlags, playFormat, startingPlayer, hostUsername);
                                OpenRoomEntry entry = new OpenRoomEntry(room, description);
                                UI.getTabRooms().getRoomListOpen().addEntry(entry);
                                if (UI.getTabRooms().getRoomListOpen().getTotalEntries() == 1 && (Game.getCurrentGame() == null || Game.getCurrentGame().getFakeReceiver() != null)) {
                                    UserAttentionNotifier.notifyUser(true, false, hostUsername, UI.getTabRooms());
                                }
                            } else {
                                UI.getTabRooms().getRoomListOpen().getEntry(roomId).show();
                            }
                        });
                        i += 7;
                        continue block28;
                    }
                    case "S": {
                        int roomId = Integer.parseInt(splitData[i + 1]);
                        int gameId = Integer.parseInt(splitData[i + 2]);
                        String usernameHost = UsernameData.updateAndGet(splitData[i + 3]);
                        String usernameGuest = UsernameData.updateAndGet(splitData[i + 4]);
                        int roomFlags = Integer.parseInt(splitData[i + 5]);
                        CardConst.PlayFormat playFormat = CardConst.PlayFormat.getPlayFormatById(Integer.parseInt(splitData[i + 6]));
                        Room.StartingPlayer startingPlayer = Room.StartingPlayer.getStartingPlayerById(Integer.parseInt(splitData[i + 7]));
                        Platform.runLater(() -> {
                            if (!UI.getTabRooms().getRoomListLive().containsEntry(roomId)) {
                                UI.getTabRooms().getRoomListOpen().removeEntry(roomId);
                                Room room = UI.getTabRooms().getRoomCoordinator().getRoomOrDefault(roomId, roomFlags, playFormat, startingPlayer, usernameHost);
                                room.setGameId(gameId);
                                room.getPlayerData(Game.GamePlayerRole.GUEST).setPlayerName(usernameGuest);
                                LiveGameEntry entry = new LiveGameEntry(room);
                                UI.getTabRooms().getRoomListLive().addEntry(entry);
                                if (Player.getCurrentRoom() != null && Player.getCurrentRoom().getRoomId() == roomId && (Player.getUsername().equals(usernameHost) || Player.getUsername().equals(usernameGuest))) {
                                    entry.select();
                                }
                                if (room.areSpectatorsAllowed() && !this.shouldSortLiveGames && UI.getTabRooms().getRoomCoordinator().checkIfRoomExists(otherRoom -> !otherRoom.areSpectatorsAllowed())) {
                                    this.shouldSortLiveGames = true;
                                }
                            }
                        });
                        i += 8;
                        continue block28;
                    }
                    case "A": {
                        int roomId = Integer.parseInt(splitData[i + 1]);
                        Platform.runLater(() -> {
                            UI.getTabRooms().getRoomListLive().removeEntry(roomId);
                            UI.getTabRooms().getRoomListOpen().removeEntry(roomId);
                            UI.getTabRooms().getRoomCoordinator().removeRoom(roomId);
                        });
                        i += 2;
                        continue block28;
                    }
                    case "H": {
                        int roomId = Integer.parseInt(splitData[i + 1]);
                        Platform.runLater(() -> {
                            RoomListEntry entry = UI.getTabRooms().getRoomListOpen().getEntry(roomId);
                            if (entry != null) {
                                entry.hide();
                            }
                        });
                        i += 2;
                        continue block28;
                    }
                    case "T": {
                        int roomId = Integer.parseInt(splitData[i + 1]);
                        int turnCount = Integer.parseInt(splitData[i + 2]);
                        int roleIdTurnPlayer = Integer.parseInt(splitData[i + 3]);
                        Platform.runLater(() -> {
                            Room room = UI.getTabRooms().getRoomCoordinator().getRoom(roomId);
                            if (room != null) {
                                room.getTurnCountProperty().set(turnCount);
                                room.getTurnPlayerRoleIdProperty().set(roleIdTurnPlayer);
                            }
                        });
                        i += 4;
                        continue block28;
                    }
                    case "P": {
                        int roomId = Integer.parseInt(splitData[i + 1]);
                        int count = Integer.parseInt(splitData[i + 2]);
                        Platform.runLater(() -> {
                            Room room = UI.getTabRooms().getRoomCoordinator().getRoom(roomId);
                            if (room != null) {
                                room.getSpectatorCountProperty().set(count);
                            }
                        });
                        this.shouldSortLiveGames = true;
                        i += 3;
                        continue block28;
                    }
                    case "E": {
                        int roomId = Integer.parseInt(splitData[i + 1]);
                        Game.GamePlayerRole rolePlayer = Game.GamePlayerRole.getRoleById(Integer.parseInt(splitData[i + 2]));
                        int count = Integer.parseInt(splitData[i + 3]);
                        Platform.runLater(() -> {
                            Room room = UI.getTabRooms().getRoomCoordinator().getRoom(roomId);
                            if (room != null) {
                                room.getPlayerData(rolePlayer).getLifeClothCountProperty().set(count);
                            }
                        });
                        i += 4;
                        continue block28;
                    }
                    case "RL": 
                    case "R": 
                    case "RR": {
                        int roomId = Integer.parseInt(splitData[i + 1]);
                        Game.GamePlayerRole rolePlayer = Game.GamePlayerRole.getRoleById(Integer.parseInt(splitData[i + 2]));
                        String imageSet = CardDataImageSet.decompressImageSetData(splitData[i + 3]);
                        String ref = splitData[i];
                        Platform.runLater(() -> {
                            Room room = UI.getTabRooms().getRoomCoordinator().getRoom(roomId);
                            if (room != null) {
                                switch (ref) {
                                    case "RL": {
                                        room.getPlayerData(rolePlayer).getLRIGAssistLeftImageProperty().set((Object)imageSet);
                                        break;
                                    }
                                    case "R": {
                                        room.getPlayerData(rolePlayer).getLRIGCenterImageProperty().set((Object)imageSet);
                                        break;
                                    }
                                    case "RR": {
                                        room.getPlayerData(rolePlayer).getLRIGAssistRightImageProperty().set((Object)imageSet);
                                    }
                                }
                            }
                        });
                        i += 4;
                        continue block28;
                    }
                    case "K": {
                        int roomId = Integer.parseInt(splitData[i + 1]);
                        Game.GamePlayerRole rolePlayer = Game.GamePlayerRole.getRoleById(Integer.parseInt(splitData[i + 2]));
                        String imageSets = CardDataImageSet.decompressImageSetData(splitData[i + 3]);
                        Platform.runLater(() -> {
                            Room room = UI.getTabRooms().getRoomCoordinator().getRoom(roomId);
                            if (room != null) {
                                room.getPlayerData(rolePlayer).getKeysImagesProperty().set((Object)imageSets);
                            }
                        });
                        i += 4;
                        continue block28;
                    }
                    case "GJ": {
                        int roomId = Integer.parseInt(splitData[i + 1]);
                        String username = UsernameData.updateAndGet(splitData[i + 2]);
                        Platform.runLater(() -> {
                            if (Player.getCurrentRoom() != null && Player.getCurrentRoom().getRoomId() == roomId) {
                                UI.getTabRooms().getControls().getControlsOpen().addPlayer(username);
                            }
                        });
                        i += 3;
                        continue block28;
                    }
                    case "GL": {
                        int roomId = Integer.parseInt(splitData[i + 1]);
                        String username = splitData[i + 2];
                        Platform.runLater(() -> {
                            if (Player.getCurrentRoom() != null && Player.getCurrentRoom().getRoomId() == roomId) {
                                UI.getTabRooms().getControls().getControlsOpen().removePlayer(username);
                            }
                        });
                        i += 3;
                        continue block28;
                    }
                }
                int recordId = Integer.parseInt(splitData[i]);
                if ((long)recordId != this.lastUpdate) {
                    this.updateLastRecordId(recordId);
                }
                Platform.runLater(() -> {
                    if (this.shouldSortLiveGames) {
                        UI.getTabRooms().sortLiveGames();
                        this.shouldSortLiveGames = false;
                    }
                    UI.getTabRooms().setLock(false);
                });
                ++i;
            }
        } else {
            String chunkToken = splitData[0].substring(1);
            String chunkData = data.substring(data.indexOf("|") + 1);
            if (!chunkToken.equals("F")) {
                Platform.runLater(() -> UI.getTabRooms().setLock(true));
                int chunkId = Integer.parseInt(chunkToken);
                if (chunkId == this.currentChunkId + 1) {
                    ++this.currentChunkId;
                    if (this.currentChunkId == 1) {
                        this.cacheChunkData = new StringBuilder();
                    }
                    this.cacheChunkData.append(chunkData);
                    this.updateLastRecordId(this.currentChunkId);
                }
                this.query.setReceiveRequestPeriod(250);
            } else if (this.cacheChunkData != null) {
                this.currentChunkId = 0;
                this.cacheChunkData.append(chunkData);
                this.parseRoomQueryData(this.cacheChunkData.toString());
                this.cacheChunkData = null;
                this.query.setReceiveRequestPeriod(2000);
            }
        }
        return true;
    }

    private boolean onProcessRoomGameStart(PacketParser pp) {
        Room currentRoom = Player.getCurrentRoom();
        if (currentRoom == null) {
            return true;
        }
        String usernameOP = pp.getDataArgument(0);
        RoomListEntry entry = UI.getTabRooms().getRoomListOpen().getEntry(currentRoom.getRoomId());
        if (entry == null || !entry.getRoom().getPlayerData(Game.GamePlayerRole.HOST).getPlayerName().equals(usernameOP)) {
            return false;
        }
        Platform.runLater(() -> {
            UI.getTabGame().closeGame(false);
            Platform.runLater(() -> this.startGame(usernameOP, entry));
        });
        return true;
    }

    private void startGame(String usernameOP, RoomListEntry entry) {
        Room currentRoom = Player.getCurrentRoom();
        if (currentRoom == null) {
            return;
        }
        UI.getTabGame().prepareNewGame(Player.getUsername(), usernameOP);
        UI.getTabGame().getFieldSceneOverlay().showGameMessage(LanguageParser.getString("UI_GAME_MESSAGE_CONNECT_WAIT_SERVER"));
        Deck selectedPlayDeck = Settings.INSTANCE.getCurrentPlayDeck();
        UI.getTabRooms().getControls().setDeckLoadButtonEnabled(true);
        RunnableConnection connectionStartGame = new RunnableConnection(() -> new RoomGuestGameAcceptAttempt(currentRoom.getRoomId()), (socketReceiver, ppStart, status) -> {
            if (status != RunnableConnection.ResponseStatus.SUCCESS) {
                if (status == RunnableConnection.ResponseStatus.TIMEOUT) {
                    new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT"), new ButtonType[0]).showAndWait();
                }
                UI.getTabGame().closeGame();
                return;
            }
            entry.hide();
            UI.getTabGame().getFieldSceneOverlay().showGameMessage(LanguageParser.getString("UI_GAME_MESSAGE_CONNECT_DECK"));
            try {
                RoomGameSendDeckAttempt attemptDeck = new RoomGameSendDeckAttempt(selectedPlayDeck);
                RunnableConnection connectionDeck = new RunnableConnection(() -> attemptDeck, (socketReceiverDeck, ppDeck, statusDeck) -> {
                    if (statusDeck != RunnableConnection.ResponseStatus.SUCCESS) {
                        if (statusDeck == RunnableConnection.ResponseStatus.TIMEOUT) {
                            new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT"), new ButtonType[0]).showAndWait();
                        } else {
                            new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_DECK"), new ButtonType[0]).showAndWait();
                        }
                        UI.getTabGame().closeGame();
                        entry.show();
                        return;
                    }
                    if (attemptDeck.prepareNextChunk()) {
                        attemptDeck.send();
                    } else {
                        UI.getTabGame().getFieldSceneOverlay().showGameMessage(LanguageParser.getString("UI_GAME_MESSAGE_CONNECT_WAIT_OPPONENT"));
                        TemporaryPacketRedirect tempRedirectDeckOP = new TemporaryPacketRedirect(Player.getNetworkFrame().getRoomsReceiver(), "SET", (ppDeckOP, statusDeckOP) -> {
                            if (statusDeckOP != TemporaryPacketRedirect.RedirectResponseStatus.SUCCESS) {
                                if (statusDeckOP == TemporaryPacketRedirect.RedirectResponseStatus.TIMEOUT) {
                                    new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT_OPPONENT"), new ButtonType[0]).showAndWait();
                                } else {
                                    new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_OPPONENT"), new ButtonType[0]).showAndWait();
                                }
                                UI.getTabGame().closeGame();
                                entry.show();
                                return;
                            }
                            if (Game.getCurrentGame() != null) {
                                return;
                            }
                            UI.getTabGame().getFieldSceneOverlay().showGameMessage(LanguageParser.getString("UI_GAME_MESSAGE_CONNECT_SETUP"));
                            int portOffset = Integer.parseInt(ppDeckOP.getDataArgument(0));
                            int gameId = Integer.parseInt(ppDeckOP.getDataArgument(1));
                            Game game = new Game(portOffset, gameId, Game.GamePlayerRole.GUEST, entry.getRoom());
                            Game.setCurrentGame(game);
                            UI.setTabInfo(UI.getTabGame(), UI.getTabInfo(UI.getTabGame()) + " [#" + gameId + "]");
                            RunnableConnection connectionGame = new RunnableConnection(() -> new GameSendPlayerConnectAttempt(portOffset), (socketReceiverGame, ppGame, statusGame) -> {
                                if (statusGame != RunnableConnection.ResponseStatus.SUCCESS) {
                                    if (statusGame == RunnableConnection.ResponseStatus.TIMEOUT) {
                                        new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT"), new ButtonType[0]).showAndWait();
                                    } else {
                                        new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_START_GAME"), new ButtonType[0]).showAndWait();
                                    }
                                    UI.getTabGame().closeGame();
                                    entry.show();
                                    return;
                                }
                                if (Game.getCurrentGame().getGameState() != Game.GameState.CONNECTING) {
                                    return;
                                }
                                Game.getCurrentGame().setGameState(Game.GameState.GAME_SETUP);
                                UI.getTabRooms().getRoomListOpen().removeEntry(currentRoom.getRoomId());
                                game.getRoom().getPlayerData(Game.GamePlayerRole.HOST).setPlayerName(usernameOP);
                                game.getRoom().getPlayerData(Game.GamePlayerRole.GUEST).setPlayerName(Player.getUsername());
                                LiveGameEntry gameEntry = new LiveGameEntry(game.getRoom());
                                UI.getTabRooms().getRoomListLive().addEntry(gameEntry);
                                gameEntry.select();
                                UI.getTabGame().initNewGame();
                                Player.getNetworkFrame().startGameReceiver(new GameReceiver(socketReceiverGame, portOffset));
                                Game.getCurrentGame().initStartActions();
                            });
                            new Thread(connectionGame).start();
                        });
                        tempRedirectDeckOP.activate();
                    }
                });
                new Thread(connectionDeck).start();
            }
            catch (SocketException | UnknownHostException ex) {
                System.err.println(ex.getMessage());
            }
        });
        new Thread(connectionStartGame).start();
    }

    @FunctionalInterface
    public static interface RoomPacketProcessor {
        public boolean process(PacketParser var1);
    }
}

