/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking.connection;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Timer;
import java.util.TimerTask;
import open.batoru.Log;
import open.batoru.Settings;
import open.batoru.networking.PacketParser;
import open.batoru.networking.UtilHash;
import open.batoru.networking.connection.STUNResolver;

public abstract class ConnectionAttempt {
    private final String token;
    private String data = "";
    private ReceiveType receiveType = ReceiveType.NONE;
    private int receiveRequestTime = 1000;
    private long receiveRequestDelay = -1L;
    private String receiveExpectedToken;
    private int receiveRetries;
    private boolean isReceiveSatisfying;
    private Timer receiveRequestTimer;
    private final DatagramSocket socket;
    private final InetAddress address = InetAddress.getByName("51.68.136.140");
    private final int sendPort;
    private STUNResolver receiveStunResolver;
    private OnConnectionReceivedHandler handlerReceived;
    private OnConnectionTimedOutHandler handlerTimedOut;
    private OnRequestPreSendHandler handlerRequestPreSend;

    public ConnectionAttempt(String token, int sendPort) throws SocketException, UnknownHostException {
        this(new DatagramSocket(), token, sendPort);
        this.receiveStunResolver = new STUNResolver(this.socket);
        if (Settings.INSTANCE.isConnectNewDirect()) {
            this.receiveStunResolver.setSendPort(sendPort);
        }
    }

    public ConnectionAttempt(DatagramSocket socket, String token, int sendPort) throws UnknownHostException {
        this.token = token;
        this.socket = socket;
        this.sendPort = sendPort;
    }

    public final void setData(String data) {
        this.data = data != null ? data : "";
    }

    public final void setOnConnectionReceived(OnConnectionReceivedHandler handlerReceived) {
        this.handlerReceived = handlerReceived;
    }

    public final void setOnConnectionTimedOut(OnConnectionTimedOutHandler handlerTimeOut) {
        this.handlerTimedOut = handlerTimeOut;
    }

    public final void setOnRequestPreSend(OnRequestPreSendHandler handlerRequestPreSend) {
        this.handlerRequestPreSend = handlerRequestPreSend;
    }

    public final void setReceive(ReceiveType receiveType) {
        this.receiveType = receiveType;
    }

    public final void setReceiveExpectedToken(String token) {
        this.receiveExpectedToken = token;
    }

    public final void setReceiveRequestPeriod(int period) {
        int oldPeriod = this.receiveRequestTime;
        this.receiveRequestTime = period;
        if (oldPeriod > 0 && period != oldPeriod && this.receiveType == ReceiveType.RELIABLE_REQUEST && this.receiveRequestTimer != null) {
            this.request();
        }
    }

    public final void setReceiveRequestDelay(long delay) {
        this.receiveRequestDelay = delay;
    }

    public void setReceivedPacketAsSatisfying() {
        this.isReceiveSatisfying = true;
    }

    public String getToken() {
        return this.token;
    }

    public void send() {
        if (!this.internalSend()) {
            return;
        }
        if (this.receiveType == ReceiveType.NONE) {
            this.socket.close();
        } else if (this.receiveType == ReceiveType.RELIABLE_REQUEST) {
            this.request();
        } else {
            this.receive();
        }
    }

    private boolean internalSend() {
        if (this.socket == null) {
            return false;
        }
        if (this.receiveType != ReceiveType.NONE && this.receiveStunResolver != null) {
            return true;
        }
        if (this.handlerRequestPreSend != null) {
            this.handlerRequestPreSend.handle();
        }
        if (this.data.isEmpty()) {
            return true;
        }
        String packetContent = this.token + "$" + UtilHash.generateChecksum(this.data) + "#" + this.data;
        byte[] buffer = packetContent.getBytes(StandardCharsets.UTF_8);
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, this.address, this.sendPort);
        try {
            this.socket.send(packet);
            return true;
        }
        catch (IOException ex) {
            Log.printMessage(ex);
            return false;
        }
    }

    private void request() {
        if (this.receiveRequestTimer != null) {
            this.receiveRequestTimer.cancel();
        }
        this.receiveRequestTimer = new Timer(true);
        this.receiveRequestTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!ConnectionAttempt.this.isReceiveSatisfying && ConnectionAttempt.this.socket != null && !ConnectionAttempt.this.socket.isClosed()) {
                    ConnectionAttempt.this.internalSend();
                } else {
                    ConnectionAttempt.this.receiveRequestTimer.cancel();
                }
            }
        }, this.receiveRequestDelay == -1L ? (long)this.receiveRequestTime : this.receiveRequestDelay, (long)this.receiveRequestTime);
    }

    private void receive() {
        try {
            this.socket.setSoTimeout(1000);
            if (this.receiveStunResolver != null) {
                this.receiveStunResolver.query(this.address);
            }
            byte[] buffer = new byte[256];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            this.socket.receive(packet);
            if (!packet.getAddress().equals(this.address)) {
                return;
            }
            if (this.receiveStunResolver != null) {
                if (!STUNResolver.isStunResponse(buffer)) {
                    return;
                }
                InetSocketAddress address = this.receiveStunResolver.parseStunResponse(buffer);
                if (address == null) {
                    return;
                }
                String publicAddress = address.getAddress().getHostAddress();
                int publicPort = address.getPort();
                this.receiveStunResolver = null;
                this.data = this.data + "|" + publicAddress + "|" + publicPort;
                this.send();
                return;
            }
            PacketParser receivedPacketParser = new PacketParser(new String(buffer).trim());
            if (!receivedPacketParser.isChecksumCorrect()) {
                ++this.receiveRetries;
                this.send();
                return;
            }
            if (this.receiveExpectedToken != null && !this.receiveExpectedToken.isEmpty() && !receivedPacketParser.getPacketDataToken().equals(this.receiveExpectedToken)) {
                return;
            }
            if (this.handlerReceived != null) {
                this.handlerReceived.handle(receivedPacketParser);
            }
        }
        catch (SocketTimeoutException ex) {
            if (++this.receiveRetries < 20) {
                this.send();
                return;
            }
            this.socket.close();
            if (this.handlerTimedOut != null) {
                this.handlerTimedOut.handle();
            }
        }
        catch (IOException ex) {
            Log.printMessage(ex);
        }
    }

    public final DatagramSocket getSocket() {
        return this.socket;
    }

    public final InetAddress getHostAddress() {
        return this.address;
    }

    public static int utilGetHeaderLength(String token) {
        return (token + "$#").length() + 32;
    }

    public static enum ReceiveType {
        NONE,
        RELIABLE,
        RELIABLE_REQUEST;

    }

    @FunctionalInterface
    public static interface OnConnectionReceivedHandler {
        public void handle(PacketParser var1);
    }

    @FunctionalInterface
    public static interface OnConnectionTimedOutHandler {
        public void handle();
    }

    @FunctionalInterface
    public static interface OnRequestPreSendHandler {
        public void handle();
    }
}

