/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking.connection;

import java.net.UnknownHostException;
import open.batoru.core.Player;
import open.batoru.networking.NetworkReceiver;
import open.batoru.networking.connection.ConnectionAttempt;

public class HeartbeatAttempt
extends ConnectionAttempt {
    private int ticksToNextSTUNQuery;

    public HeartbeatAttempt(NetworkReceiver receiver) throws UnknownHostException {
        super(receiver.getSocket(), "0", receiver.getSendPort());
        this.setReceive(ConnectionAttempt.ReceiveType.RELIABLE_REQUEST);
        this.setReceiveRequestPeriod(1000);
        this.setReceiveRequestDelay(0L);
        this.setReceiveExpectedToken("0X");
        this.setOnRequestPreSend(() -> {
            if (receiver.getStunResolver() != null && --this.ticksToNextSTUNQuery <= 0) {
                this.ticksToNextSTUNQuery = 10;
                receiver.getStunResolver().query(this.getHostAddress());
            }
            if (receiver.getPublicAddress() == null || receiver.getPublicPort() == 0) {
                return;
            }
            this.setData(Player.getKeyHash() + "|" + System.currentTimeMillis() + "|" + receiver.getPublicAddress() + "|" + receiver.getPublicPort());
        });
    }
}

