/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking.connection;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import open.batoru.core.Deck;
import open.batoru.core.Player;
import open.batoru.networking.connection.ConnectionAttempt;

public class RoomGameSendDeckAttempt
extends ConnectionAttempt {
    private final Deck deck;
    private final List<String> dataChunks = new ArrayList<String>();
    private int currentChunk;
    private final String dataHeader;

    public RoomGameSendDeckAttempt(Deck deck) throws SocketException, UnknownHostException {
        super("DK", 42005);
        this.setReceive(ConnectionAttempt.ReceiveType.RELIABLE);
        this.setReceiveExpectedToken("DKX");
        this.deck = deck;
        this.dataHeader = Player.getUsername() + "|" + Player.getKeyHash() + "|";
        this.setData(this.dataHeader.substring(0, this.dataHeader.length() - 1));
    }

    public boolean prepareNextChunk() {
        if (this.dataChunks.isEmpty()) {
            String fullData = this.deck.exportAsCompressedData();
            int chunkSize = 253 - (RoomGameSendDeckAttempt.utilGetHeaderLength(this.getToken()) + this.dataHeader.length());
            this.prepareChunkData(fullData, chunkSize);
            this.currentChunk = -1;
        }
        if (++this.currentChunk < this.dataChunks.size()) {
            this.setData(this.dataHeader + this.dataChunks.get(this.currentChunk));
            return true;
        }
        return false;
    }

    private void prepareChunkData(String fullData, int chunkSize) {
        int numOfChunks = (int)Math.ceil((double)fullData.length() / (double)chunkSize);
        for (int i = 0; i < numOfChunks; ++i) {
            int startIndex = i * chunkSize;
            int endIndex = Math.min(startIndex + chunkSize, fullData.length());
            String chunk = "~" + String.valueOf(i + 1 < numOfChunks ? Integer.valueOf(i + 1) : "F") + "|" + fullData.substring(startIndex, endIndex);
            this.dataChunks.add(chunk);
            System.out.println(chunk);
        }
    }
}

