/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking.connection;

import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javafx.application.Platform;
import open.batoru.networking.PacketParser;
import open.batoru.networking.connection.ConnectionAttempt;

public record RunnableConnection(SampleConnectionHandler handlerSample, OnResponseReceivedHandler handlerOnReceived) implements Runnable
{
    @Override
    public void run() {
        try {
            ConnectionAttempt attempt = this.handlerSample.getConnection();
            attempt.setOnConnectionTimedOut(() -> this.callHandler(attempt.getSocket(), null, ResponseStatus.TIMEOUT));
            attempt.setOnConnectionReceived(pp -> this.callHandler(attempt.getSocket(), pp, pp.getPacketData().equals("!1") || pp.getDataArgument(0).equals("!1") || !pp.isDataResponseCode() ? ResponseStatus.SUCCESS : ResponseStatus.INVALID));
            attempt.send();
        }
        catch (SocketException | UnknownHostException ex) {
            System.err.println(ex.getMessage());
            this.callHandler(null, null, ResponseStatus.ERROR);
        }
    }

    private void callHandler(DatagramSocket socketReceiver, PacketParser pp, ResponseStatus status) {
        Platform.runLater(() -> this.handlerOnReceived.handle(socketReceiver, pp, status));
    }

    @FunctionalInterface
    public static interface SampleConnectionHandler {
        public ConnectionAttempt getConnection() throws SocketException, UnknownHostException;
    }

    @FunctionalInterface
    public static interface OnResponseReceivedHandler {
        public void handle(DatagramSocket var1, PacketParser var2, ResponseStatus var3);
    }

    public static enum ResponseStatus {
        ERROR,
        TIMEOUT,
        INVALID,
        SUCCESS;

    }
}

