/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking.connection;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import open.batoru.Log;
import open.batoru.Settings;
import open.batoru.networking.PacketParser;
import open.batoru.networking.UtilHash;

public class STUNResolver {
    private final DatagramSocket socket;
    private int sendPort = 3478;

    public STUNResolver(DatagramSocket socket) {
        this.socket = socket;
    }

    public void setSendPort(int sendPort) {
        this.sendPort = sendPort;
    }

    public void query(InetAddress address) {
        byte[] buffer = this.buildStunRequest();
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length, address, this.sendPort);
        try {
            this.socket.send(packet);
        }
        catch (IOException ex) {
            Log.printMessage(ex);
        }
    }

    public InetSocketAddress parseStunResponse(byte[] response) throws UnknownHostException {
        if (Settings.INSTANCE.isConnectNewDirect()) {
            PacketParser pp = new PacketParser(new String(response).trim());
            if (!pp.isChecksumCorrect() || pp.getDataArgsNum() < 2) {
                return null;
            }
            return new InetSocketAddress(pp.getDataArgument(0), Integer.parseInt(pp.getDataArgument(1)));
        }
        ByteBuffer buffer = ByteBuffer.wrap(response);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.getShort();
        buffer.getShort();
        buffer.getInt();
        byte[] transactionId = new byte[12];
        buffer.get(transactionId);
        while (buffer.remaining() > 4) {
            short type = buffer.getShort();
            short length = buffer.getShort();
            if (type == 1 && length == 8) {
                buffer.get();
                byte family = buffer.get();
                int port = buffer.getShort() & 0xFFFF;
                byte[] ipBytes = new byte[family == 1 ? 4 : 16];
                buffer.get(ipBytes);
                return new InetSocketAddress(InetAddress.getByAddress(ipBytes), port);
            }
            buffer.position(buffer.position() + length);
        }
        return null;
    }

    private byte[] buildStunRequest() {
        if (Settings.INSTANCE.isConnectNewDirect()) {
            return ("AA$" + UtilHash.generateChecksum("") + "#").getBytes();
        }
        ByteBuffer buffer = ByteBuffer.allocate(20);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putShort((short)1);
        buffer.putShort((short)0);
        buffer.putInt(554869826);
        buffer.putInt((int)(Math.random() * 2.147483647E9));
        buffer.putInt((int)(Math.random() * 2.147483647E9));
        buffer.putInt((int)(Math.random() * 2.147483647E9));
        return buffer.array();
    }

    public static boolean isStunResponse(byte[] data) {
        if (Settings.INSTANCE.isConnectNewDirect()) {
            return data.length > 3 && data[0] == 65 && data[1] == 65 && data[2] == 88;
        }
        if (data.length < 20) {
            return false;
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.BIG_ENDIAN);
        short messageType = buffer.getShort(0);
        int magicCookie = buffer.getInt(4);
        return messageType == 257 && magicCookie == 554869826;
    }
}

