/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking.service;

import java.io.IOException;
import java.nio.file.Path;
import javafx.application.Platform;
import open.batoru.Log;
import open.batoru.networking.HTTPFileDownloader;
import open.batoru.networking.UtilHash;

public class GameDataDownloadService {
    private final String checksum;
    private final OnDownloadCompletedHandler handler;

    public GameDataDownloadService(String checksum, OnDownloadCompletedHandler handler) {
        this.checksum = checksum;
        this.handler = handler;
    }

    public GameDataDownloadService(int gameId, OnDownloadCompletedHandler handler) {
        this.checksum = "spec/" + gameId;
        this.handler = handler;
    }

    public void start() {
        Path pathTemp = Path.of("downloads/temp/" + this.checksum + ".replay", new String[0]);
        new Thread(() -> {
            HTTPFileDownloader downloader = new HTTPFileDownloader();
            downloader.setOnDownloadCompleted(() -> {
                String hashDownloaded = UtilHash.generateFileHash(pathTemp);
                if (this.checksum.startsWith("spec") || hashDownloaded.equals(this.checksum)) {
                    Platform.runLater(() -> this.handler.handle(pathTemp));
                }
            });
            try {
                downloader.download("https://open.batoru.moe/game/downloads/temp/" + this.checksum + ".replay", pathTemp);
            }
            catch (IOException | InterruptedException ex) {
                Log.printMessage(ex);
            }
        }).start();
    }

    @FunctionalInterface
    public static interface OnDownloadCompletedHandler {
        public void handle(Path var1);
    }
}

