/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.networking.service;

import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.rooms.Room;
import open.batoru.networking.FakeGameReceiver;
import open.batoru.networking.connection.GameSendPlayerReconnectAttempt;
import open.batoru.networking.connection.RunnableConnection;
import open.batoru.networking.service.GameDataDownloadService;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class GameReconnectService {
    private final int portOffset;
    private final int gameId;
    private Thread thread;

    public GameReconnectService(int portOffset, int gameId) {
        this.portOffset = portOffset;
        this.gameId = gameId;
    }

    public void start() {
        if (this.thread != null) {
            return;
        }
        Room room = UI.getTabRooms().getRoomCoordinator().getRoomByUsername(Player.getUsername());
        if (room == null || UI.getTabRooms().getRoomListLive().getEntry(room.getRoomId()) == null) {
            return;
        }
        UI.getTabRooms().getRoomListLive().getEntry(room.getRoomId()).select();
        Game.GamePlayerRole currentRole = room.getPlayerData(Game.GamePlayerRole.HOST).getPlayerName().equals(Player.getUsername()) ? Game.GamePlayerRole.HOST : Game.GamePlayerRole.GUEST;
        Game game = new Game(this.portOffset, this.gameId, currentRole, room);
        Game.setCurrentGame(game);
        if (currentRole == Game.GamePlayerRole.HOST) {
            UI.getTabRooms().getControls().toggleRoomControls(true);
            UI.getTabRooms().getControls().getControlsOpen().setListControlsEnabled(false);
        }
        UI.getTabGame().prepareNewGame(Player.getUsername(), room.getPlayerData(Game.GamePlayerRole.getOpponentRole(currentRole)).getPlayerName());
        UI.getTabGame().getFieldSceneOverlay().showGameMessage(LanguageParser.getString("UI_GAME_MESSAGE_RECONNECT_GAME"));
        UI.setTabInfo(UI.getTabGame(), UI.getTabInfo(UI.getTabGame()) + " [#" + this.gameId + "]");
        RunnableConnection connectionGame = new RunnableConnection(() -> new GameSendPlayerReconnectAttempt(this.portOffset), (socketReceiverGame, ppGame, statusGame) -> {
            if (statusGame != RunnableConnection.ResponseStatus.SUCCESS) {
                Alert alert = new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_RECONNECT"), new ButtonType[0]);
                alert.showAndWait();
                UI.getTabRooms().getRoomListLive().getEntry(room.getRoomId()).deselect();
                UI.getTabRooms().getRoomListLive().removeEntry(room.getRoomId());
                UI.getTabGame().closeGame();
                UI.getTabRooms().getControls().toggleRoomControls(false);
                UI.getTabRooms().getControls().getControlsOpen().setListControlsEnabled(true);
                return;
            }
            UI.getTabGame().getFieldSceneOverlay().showGameMessage(LanguageParser.getString("UI_GAME_MESSAGE_RECONNECT_DOWNLOAD"));
            String checksum = ppGame.getPacketData();
            GameDataDownloadService service = new GameDataDownloadService(checksum, pathTemp -> {
                List<String> data;
                try {
                    data = Files.readAllLines(pathTemp);
                }
                catch (IOException ex) {
                    new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_RECONNECT_DOWNLOAD") + "\n" + ex.getMessage(), new ButtonType[0]).showAndWait();
                    return;
                }
                Game.getCurrentGame().setGameState(Game.GameState.GAME_SETUP);
                UI.getTabGame().initNewGame();
                data.removeFirst();
                FakeGameReceiver fakeReceiverGame = new FakeGameReceiver(data, socketReceiverGame, this.portOffset);
                Player.getNetworkFrame().startGameReceiver(fakeReceiverGame);
                Game.getCurrentGame().setFakeReceiver(fakeReceiverGame);
                UI.getTabGame().getFieldSceneOverlay().showGameMessage(LanguageParser.getString("UI_GAME_MESSAGE_RECONNECT_FASTFORWARD"));
                UI.getTabGame().getFieldSceneOverlay().showBlackScreen(true);
                Game.getCurrentGame().getGameSpeedController().setMultiplier(0.01);
                Game.getCurrentGame().initStartActions();
            });
            service.start();
        });
        this.thread = new Thread(connectionGame);
        this.thread.start();
    }
}

