/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.Collator;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.text.Font;

public final class LanguageParser {
    private static final Properties tokensML = new Properties();
    private static Collator collator;
    public static final ObservableList<String> OPTION_LANGUAGES;

    public static void gatherAvailableLanguages() {
        Path pathLang = Path.of("lang/", new String[0]);
        try (Stream<Path> stream = Files.list(pathLang);){
            stream.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".txt")).forEach(path -> {
                String filename = path.getFileName().toString().replace(".txt", "");
                String langDisplay = "?";
                try (BufferedReader reader = Files.newBufferedReader(path);){
                    String firstLine = reader.readLine();
                    if (firstLine.startsWith("LANG_DISPLAY=")) {
                        langDisplay = firstLine.substring("LANG_DISPLAY=".length());
                    }
                }
                catch (IOException ex) {
                    System.err.println("Warning: Invalid lang file: " + filename);
                }
                OPTION_LANGUAGES.add((Object)(filename + " (" + langDisplay + ")"));
            });
            Collections.sort(OPTION_LANGUAGES);
        }
        catch (IOException ex) {
            System.err.println("Error: Couldn't read language files. (" + ex.getMessage() + ")");
        }
    }

    public static void load(String lang) {
        block9: {
            try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(Path.of("lang/" + lang + ".txt", new String[0]), new OpenOption[0]));){
                String localeTag;
                tokensML.load(reader);
                String listFonts = tokensML.getProperty("UI_FONT");
                if (listFonts != null) {
                    String[] fonts;
                    for (String name : fonts = listFonts.split(",")) {
                        name = name.trim();
                        if (!Font.getFontNames().contains(name)) continue;
                        tokensML.setProperty("UI_FONT", name);
                        break;
                    }
                }
                collator = Collator.getInstance(Locale.forLanguageTag((localeTag = tokensML.getProperty("LANG_LOCALE_TAG")) != null ? localeTag : lang));
            }
            catch (IOException ex) {
                System.err.println("Warning: Failed to load lang file (" + lang + ").");
                if (lang.equals("en")) break block9;
                System.err.println("Warning: Loading English (en) as the default language...");
                LanguageParser.load("en");
            }
        }
    }

    public static boolean isStringUndefined(String token) {
        return !tokensML.containsKey(token);
    }

    public static String getString(String token) {
        return tokensML.getProperty(token) != null ? tokensML.getProperty(token) : token;
    }

    public static String getFormattedString(String token, int value) {
        String string = LanguageParser.getString(token);
        return !string.isEmpty() ? string.replace("$1", String.valueOf(value)) : token;
    }

    public static Collator getCollator() {
        return collator;
    }

    private LanguageParser() {
    }

    static {
        OPTION_LANGUAGES = FXCollections.observableArrayList();
    }
}

