/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import open.batoru.core.Deck;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.CardLoader;
import open.batoru.parsers.LanguageParser;

public final class RestrictedCardsParser {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load() {
        try (BufferedReader file = Files.newBufferedReader(Path.of("restricted.list", new String[0]));){
            String line;
            block17: while ((line = file.readLine()) != null) {
                String value;
                String imageSet;
                Card cardObject;
                int token;
                if (line.isEmpty() || line.charAt(0) == '#' || (token = line.indexOf("=")) == -1 || (cardObject = CardLoader.getCardByImageSet(imageSet = line.substring(0, token))) == null) continue;
                int tokenComment = line.indexOf(" ");
                switch (value = line.substring(token + 1, tokenComment != -1 ? tokenComment : line.length())) {
                    case "2": {
                        cardObject.setBanlistRestriction(RestrictType.UP_TO_TWO);
                        continue block17;
                    }
                    case "0": {
                        cardObject.setBanlistRestriction(RestrictType.DISABLED);
                        continue block17;
                    }
                    case "T": {
                        cardObject.setBanlistRestriction(RestrictType.TOKEN);
                        continue block17;
                    }
                }
                Card cardObjectOther = CardLoader.getCardByImageSet(value);
                if (cardObjectOther == null) continue;
                cardObject.addBanlistSimultaneousCard(cardObjectOther);
                cardObjectOther.addBanlistSimultaneousCard(cardObject);
            }
            return;
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public static String formatLRIGLimitMismatchWarningText() {
        return LanguageParser.getString("RESTRICT_INFO_LRIG");
    }

    public static String formatRestrictTooltipText(RestrictType restrictType) {
        Object tooltipText;
        if (restrictType != RestrictType.UP_TO_TWO) {
            tooltipText = LanguageParser.getString("RESTRICT_INFO_DISABLED");
            if (restrictType == RestrictType.TOKEN) {
                tooltipText = LanguageParser.getString("CATALOG_FILTER_RESTRICT_TOKEN") + ". " + (String)tooltipText;
            }
        } else {
            tooltipText = LanguageParser.getFormattedString("RESTRICT_INFO_COUNT", 2) + " (" + CardConst.PlayFormat.DIVA.getLabel() + ")";
        }
        return tooltipText;
    }

    public static String formatSimultaneousRestrictTooltipText(Card cardObject) {
        StringBuilder tooltipText = new StringBuilder(LanguageParser.getString("RESTRICT_INFO_SIMULTANEOUS") + "\n");
        for (Card cardObjectOther : cardObject.getBanlistSimultaneousList()) {
            tooltipText.append("- ").append(cardObjectOther.getName()).append("\n");
        }
        return tooltipText.toString();
    }

    public static String formatSpecialRestrictTooltipText(Deck deck, String imageSet) {
        return LanguageParser.getString("RESTRICT_INFO_SPECIAL") + "\n" + deck.getSpecialRestrictText(imageSet);
    }

    private RestrictedCardsParser() {
    }

    public static enum RestrictType {
        NONE("CATALOG_FILTER_ANY"),
        UP_TO_TWO("CATALOG_FILTER_RESTRICT_UP_TO_TWO"),
        DISABLED("CATALOG_FILTER_RESTRICT_DISABLED"),
        TOKEN("CATALOG_FILTER_RESTRICT_TOKEN");

        private final String label;

        private RestrictType(String label) {
            this.label = LanguageParser.getString(label);
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum SpecialRestrictType {
        SIMULTANEOUS,
        UNRELEASED;

    }
}

