/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.parsers;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class SettingsParser {
    private final Properties settings = new Properties();

    public SettingsParser() {
        this.loadDefaults();
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(Path.of("settings.cfg", new String[0]), new OpenOption[0]));){
            this.settings.load(reader);
        }
        catch (IOException ex) {
            System.err.println("Warning: Failed to load settings.cfg file. Using defaults instead.");
        }
    }

    private void loadDefaults() {
        this.settings.setProperty("ANI_SPEED", "0.25");
        this.settings.setProperty("PLAY_ANI_PHASE", "1");
        this.settings.setProperty("ALWAYS_SHOW_PREVIEW_IMAGESET", "0");
        this.settings.setProperty("AUTO_SAVE_REPLAYS", "0");
        this.settings.setProperty("AUTO_CONFIRM_SIGNI", "1");
        this.settings.setProperty("AUTO_CONFIRM_SPELL", "1");
        this.settings.setProperty("AUTO_CONFIRM_ACTION", "1");
        this.settings.setProperty("AUTO_CONFIRM_LRIG", "1");
        this.settings.setProperty("AUTO_CONFIRM_TARGETS", "1");
        this.settings.setProperty("AUTO_SKIP_SIGNI", "0");
        this.settings.setProperty("AUTO_SKIP_LRIG", "0");
        this.settings.setProperty("EXPAND_ENER_PAY", "0");
        this.settings.setProperty("REORDER_AT_ONCE", "0");
        this.settings.setProperty("DECK", "decks/WX24D1_WhiteAltHope.deck");
        this.settings.setProperty("LANG", "en");
        this.settings.setProperty("UI_THEME", "default");
        this.settings.setProperty("LAST_ROOM_DESC", "");
        this.settings.setProperty("LAST_ROOM_FORMAT", "2");
        this.settings.setProperty("LAST_ROOM_START_PLAYER", "0");
        this.settings.setProperty("LAST_ROOM_FLAGS", "3");
        this.settings.setProperty("LAST_DECK_FORMAT", "0");
        this.settings.setProperty("NOTIFY_WINDOW_FLASH", "1");
        this.settings.setProperty("NOTIFY_ALERT_SOUND", "1");
        this.settings.setProperty("LAST_AUTH_REMEMBER_USERNAME", "");
        this.settings.setProperty("LAST_AUTH_REMEMBER_KEY", "");
        this.settings.setProperty("CONNECT_NEW_DIRECT", "1");
        this.settings.setProperty("SURVEY_DONE", "0");
    }

    public void writeSettings() {
        try (FileWriter writer = new FileWriter("settings.cfg");){
            this.settings.store(writer, null);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public String getValue(String key) {
        return this.settings.getProperty(key);
    }

    public int getIntegerValue(String key) {
        return Integer.parseInt(this.settings.getProperty(key));
    }

    public double getDoubleValue(String key) {
        return Double.parseDouble(this.settings.getProperty(key));
    }

    public void updateValue(String key, String value) {
        this.settings.replace(key, value);
    }
}

