/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.parsers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import open.batoru.data.Card;
import open.batoru.data.CardLoader;
import open.batoru.parsers.LanguageParser;

public final class UnreleasedCardsParser {
    public static void load() {
        try {
            Path path = Path.of("unreleased.list", new String[0]);
            List<String> lines = Files.readAllLines(path);
            HashMap<String, String> mapUnreleasedCards = new HashMap<String, String>();
            ZoneId zone = ZoneId.of("Asia/Tokyo");
            LocalDate currentDate = LocalDate.now(zone);
            ListIterator<String> it = lines.listIterator();
            int initialSize = lines.size();
            while (it.hasNext()) {
                String line = (String)it.next();
                int token = line.indexOf("=");
                if (token == -1) continue;
                String date = line.substring(0, token);
                String prefix = line.substring(token + 1);
                LocalDate releaseDate = LocalDate.parse(date);
                if (currentDate.isBefore(releaseDate)) {
                    mapUnreleasedCards.put(prefix, date);
                    continue;
                }
                it.remove();
            }
            if (lines.size() != initialSize) {
                Files.write(path, lines, new OpenOption[0]);
            }
            if (!mapUnreleasedCards.isEmpty()) {
                for (Card cardObject : CardLoader.getDataCardObjects()) {
                    String primaryImageSet = cardObject.getImageSets().getPrimaryImageSet();
                    String date = (String)mapUnreleasedCards.get(primaryImageSet);
                    if (date == null) {
                        int tokenPrefix = primaryImageSet.lastIndexOf("-");
                        if (tokenPrefix == -1) continue;
                        date = (String)mapUnreleasedCards.get(primaryImageSet.substring(0, tokenPrefix));
                    }
                    if (date == null) continue;
                    cardObject.setReleaseDate(date);
                }
            }
        }
        catch (IOException | DateTimeParseException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public static String formatUnreleasedTooltipText(Card cardObject) {
        return LanguageParser.getString("RESTRICT_INFO_UNRELEASED") + "\n" + cardObject.getReleaseDate();
    }

    private UnreleasedCardsParser() {
    }
}

