/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.replays;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import open.batoru.core.Game;
import open.batoru.data.CardConst;

public class ReplayDataParser {
    public static final int MIN_SUPPORTED_REPLAY_VERSION = 1300;
    public static final String MIN_SUPPORTED_REPLAY_VERSION_STRING = "0.13.0-beta";
    private final Path path;
    private List<String> data;
    private int replayVersion;
    private String replayVersionString;
    private ParseResult lastParseResult;
    private String username;
    private String usernameOP;
    private Game.GamePlayerRole rolePlayer;
    private int gameId;
    private CardConst.PlayFormat playFormat;
    private int totalTurns;
    private boolean isWin;
    private String imageSetOwnCenterLRIG;
    private String imageSetOwnAssistLeftLRIG;
    private String imageSetOwnAssistRightLRIG;
    private String imageSetOPCenterLRIG;
    private String imageSetOPAssistLeftLRIG;
    private String imageSetOPAssistRightLRIG;
    private int lifeClothOwnCount;
    private int lifeClothOPCount;
    private String imageSetsOwnKeys;
    private String imageSetsOPKeys;

    public ReplayDataParser(Path path) {
        this.path = path;
    }

    public void parse() {
        try {
            this.data = Files.readAllLines(this.path);
        }
        catch (IOException | NullPointerException ex) {
            this.lastParseResult = ParseResult.FAILED_TO_READ;
            return;
        }
        if (this.data.size() < 3) {
            this.lastParseResult = ParseResult.INVALID_FORMAT;
            return;
        }
        String[] headerArgs = this.data.getFirst().split("\\|", -1);
        if (headerArgs.length < 7 || !headerArgs[0].equals("O!b")) {
            this.lastParseResult = ParseResult.INVALID_FORMAT;
            return;
        }
        String version = headerArgs[1];
        this.username = headerArgs[2];
        this.usernameOP = headerArgs[3];
        try {
            this.rolePlayer = Game.GamePlayerRole.getRoleById(Integer.parseInt(headerArgs[4]));
            this.gameId = Integer.parseInt(headerArgs[5]);
            this.playFormat = CardConst.PlayFormat.getPlayFormatById(Integer.parseInt(headerArgs[6]));
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException ex) {
            this.lastParseResult = ParseResult.INVALID_FORMAT;
            return;
        }
        if (this.data.get(1).startsWith("Info")) {
            String[] infoArgs = this.data.get(1).split("\\|", -1);
            try {
                this.totalTurns = Integer.parseInt(infoArgs[1]);
                this.isWin = Boolean.parseBoolean(infoArgs[2]);
                this.imageSetOwnCenterLRIG = infoArgs[3];
                this.imageSetOwnAssistLeftLRIG = infoArgs[4];
                this.imageSetOwnAssistRightLRIG = infoArgs[5];
                this.imageSetOPCenterLRIG = infoArgs[6];
                this.imageSetOPAssistLeftLRIG = infoArgs[7];
                this.imageSetOPAssistRightLRIG = infoArgs[8];
                this.lifeClothOwnCount = Integer.parseInt(infoArgs[9]);
                this.lifeClothOPCount = Integer.parseInt(infoArgs[10]);
                this.imageSetsOwnKeys = infoArgs[11];
                this.imageSetsOPKeys = infoArgs[12];
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException ex) {
                System.err.println("Warning: Invalid \"Info\" format in replay: " + String.valueOf(this.path.getFileName()) + " (" + ex.getMessage() + ")");
            }
            this.data.remove(1);
        } else {
            System.err.println("Warning: Missing \"Info\" data in replay: " + String.valueOf(this.path.getFileName()));
        }
        this.replayVersionString = version;
        String[] parts = version.split("-");
        String[] semver = parts[0].split("\\.");
        int major = Integer.parseInt(semver[0]);
        int minor = semver.length > 1 ? Integer.parseInt(semver[1]) : 0;
        int patch = semver.length > 2 ? Integer.parseInt(semver[2]) : 0;
        int replayVersion = major * 10000 + minor * 100 + patch;
        if (replayVersion < 1300) {
            this.lastParseResult = ParseResult.VERSION_NOT_SUPPORTED;
            return;
        }
        this.data.removeFirst();
        this.lastParseResult = ParseResult.SUCCESS;
    }

    public String getFileName() {
        return this.path.getFileName().toString();
    }

    public List<String> getData() {
        return this.data;
    }

    public ParseResult getLastParseResult() {
        return this.lastParseResult;
    }

    public int getReplayVersion() {
        return this.replayVersion;
    }

    public String getReplayVersionAsString() {
        return this.replayVersionString;
    }

    public String getUsername() {
        return this.username;
    }

    public String getUsernameOP() {
        return this.usernameOP;
    }

    public Game.GamePlayerRole getPlayerRole() {
        return this.rolePlayer;
    }

    public int getGameId() {
        return this.gameId;
    }

    public CardConst.PlayFormat getPlayFormat() {
        return this.playFormat;
    }

    public int getTotalTurns() {
        return this.totalTurns;
    }

    public boolean isWin() {
        return this.isWin;
    }

    public String getOwnCenterLRIGImageSet() {
        return this.imageSetOwnCenterLRIG;
    }

    public String getOwnAssistLeftLRIGImageSet() {
        return this.imageSetOwnAssistLeftLRIG;
    }

    public String getOwnAssistRightLRIGImageSet() {
        return this.imageSetOwnAssistRightLRIG;
    }

    public String getOPCenterLRIGImageSet() {
        return this.imageSetOPCenterLRIG;
    }

    public String getOPAssistLeftLRIGImageSet() {
        return this.imageSetOPAssistLeftLRIG;
    }

    public String getOPAssistRightLRIGImageSet() {
        return this.imageSetOPAssistRightLRIG;
    }

    public int getOwnLifeClothCount() {
        return this.lifeClothOwnCount;
    }

    public int getOPLifeClothCount() {
        return this.lifeClothOPCount;
    }

    public String getOwnKeysImageSets() {
        return this.imageSetsOwnKeys;
    }

    public String getOPKeysImageSets() {
        return this.imageSetsOPKeys;
    }

    public static enum ParseResult {
        FAILED_TO_READ,
        INVALID_FORMAT,
        VERSION_NOT_SUPPORTED,
        SUCCESS;

    }
}

