/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.replays;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.StackPane;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.rooms.Room;
import open.batoru.game.overlay.OverlayReplayControls;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.networking.FakeGameReceiver;
import open.batoru.networking.NetworkFrame;
import open.batoru.networking.SpecFakeGameReceiver;
import open.batoru.networking.UsernameData;
import open.batoru.parsers.LanguageParser;
import open.batoru.replays.ReplayDataParser;
import open.batoru.ui.UI;
import open.batoru.ui.UtilDispose;

public class ReplayStartProcedure {
    public static void play(ReplayDataParser parser) {
        Room fakeRoom = new Room(0, 0, parser.getPlayFormat(), Room.StartingPlayer.RANDOM, parser.getUsername());
        fakeRoom.getPlayerData(Game.GamePlayerRole.GUEST).setPlayerName(parser.getUsernameOP());
        ReplayStartProcedure.play(parser, fakeRoom);
    }

    public static void playAsSpectator(ReplayDataParser parser, Room room) {
        ReplayStartProcedure.play(parser, room);
    }

    private static void play(ReplayDataParser parser, Room room) {
        FakeGameReceiver fakeReceiverGame;
        ReplayDataParser.ParseResult result = parser.getLastParseResult();
        if (result != ReplayDataParser.ParseResult.SUCCESS) {
            switch (result) {
                case FAILED_TO_READ: {
                    new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_REPLAY") + "\n" + parser.getFileName(), new ButtonType[0]).showAndWait();
                    break;
                }
                case INVALID_FORMAT: {
                    new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_REPLAY_FORMAT"), new ButtonType[0]).showAndWait();
                    break;
                }
                case VERSION_NOT_SUPPORTED: {
                    new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_REPLAY_VERSION") + "\n" + parser.getReplayVersionAsString() + " < 0.13.0-beta", new ButtonType[0]).showAndWait();
                    break;
                }
                default: {
                    new Alert(Alert.AlertType.ERROR, "Unknown error!", new ButtonType[0]).showAndWait();
                }
            }
            return;
        }
        if (Player.getNetworkFrame() == null) {
            NetworkFrame networkFrame = new NetworkFrame();
            Player.setNetworkFrame(networkFrame);
        }
        UI.getTabGame().prepareNewGame(UsernameData.getClean(parser.getUsername()), UsernameData.getClean(parser.getUsernameOP()));
        Game game = new Game(0, parser.getGameId(), parser.getPlayerRole(), room);
        Game.setCurrentGame(game);
        game.getRoom().getPlayerData(parser.getPlayerRole()).setPlayerName(UsernameData.getClean(parser.getUsername()));
        game.getRoom().getPlayerData(Game.GamePlayerRole.getOpponentRole(parser.getPlayerRole())).setPlayerName(UsernameData.getClean(parser.getUsernameOP()));
        UI.setTabInfo(UI.getTabGame(), UI.getTabInfo(UI.getTabGame()) + " [#" + parser.getGameId() + "]");
        Game.getCurrentGame().setGameState(Game.GameState.GAME_SETUP);
        UI.getTabGame().initNewGame();
        if (room.getRoomId() == 0) {
            fakeReceiverGame = new FakeGameReceiver(parser.getData(), null, 0);
            OverlayReplayControls replayControls = new OverlayReplayControls(fakeReceiverGame.getFinalOrder());
            UI.getTabGame().getFieldSceneOverlay().getNode().getChildren().addFirst((Object)replayControls);
            StackPane.setAlignment((Node)replayControls, (Pos)Pos.CENTER_LEFT);
            StackPane.setMargin((Node)UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar(), (Insets)new Insets(0.0, 0.0, 0.0, 25.0));
            StackPane.setMargin((Node)UI.getTabGame().getFieldSceneOverlay().getEffectsPane(), (Insets)new Insets(0.0, 0.0, 0.0, 25.0));
            Game.getCurrentGame().getActionQueue().setOnActionDispatched(replayControls::setCurrentOrder);
        } else {
            fakeReceiverGame = new SpecFakeGameReceiver(parser.getData(), parser.getGameId());
            game.getGameSpeedController().setMultiplier(0.01);
            UI.getTabGame().getFieldSceneOverlay().showGameMessage(LanguageParser.getString("UI_GAME_MESSAGE_RECONNECT_FASTFORWARD"));
            UI.getTabGame().getFieldSceneOverlay().showBlackScreen(true);
            Button buttonCancel = OverlayWindow.createButton(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_CANCEL"));
            buttonCancel.setOnAction(e -> UI.getTabGame().closeGame(false));
            StackPane.setMargin((Node)buttonCancel, (Insets)new Insets(100.0, 0.0, 0.0, 0.0));
            UtilDispose.TEMP.setOnDisposed((Node)buttonCancel, () -> buttonCancel.setOnAction(null));
            UI.getTabGame().getFieldSceneOverlay().getBlackScreenNode().getChildren().add((Object)buttonCancel);
            UtilDispose.TEMP.attachChildDisposeListener((Node)UI.getTabGame().getFieldSceneOverlay().getBlackScreenNode());
        }
        Player.getNetworkFrame().startGameReceiver(fakeReceiverGame);
        Game.getCurrentGame().setFakeReceiver(fakeReceiverGame);
        UI.getTabGame().getFieldSceneOverlay().getGameControls().getButtonSurrender().setVisible(false);
        UI.getTabGame().getFieldSceneOverlay().setReportButtonVisible(false);
        if (room.getRoomId() != 0) {
            UI.getTabGame().getFieldSceneOverlay().updateSpectatorControls(room.getSpectatorCountProperty().get() + 1);
        }
        Game.getCurrentGame().initStartActions();
    }

    private ReplayStartProcedure() {
    }
}

