/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.replays;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import open.batoru.Main;
import open.batoru.Settings;
import open.batoru.core.Game;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class UtilReplays {
    public static boolean canWatchGames() {
        return Game.getCurrentGame() == null && !UI.isTabEnabled(UI.getTabGame());
    }

    public static File showSaveReplayDialog(int gameId) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Replay");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Open!batoru Replay Data", new String[]{"*.replay"}));
        try {
            Path directory = Path.of("replays/", new String[0]);
            if (!Files.exists(directory, new LinkOption[0])) {
                Files.createDirectory(directory, new FileAttribute[0]);
            }
            fileChooser.setInitialDirectory(directory.toFile());
        }
        catch (IOException ex) {
            fileChooser.setInitialDirectory(new File("."));
        }
        fileChooser.setInitialFileName("game-" + gameId);
        return fileChooser.showSaveDialog((Window)Main.getStage());
    }

    public static void saveReplay(Path pathTemp, File newFile) {
        try {
            Path pathDest = newFile.getPath().endsWith(".replay") ? newFile.toPath() : newFile.toPath().resolveSibling(newFile.getName() + ".replay");
            Files.move(pathTemp, pathDest, StandardCopyOption.REPLACE_EXISTING);
            if (!Settings.INSTANCE.shouldAutoSaveReplays()) {
                new Alert(Alert.AlertType.INFORMATION, LanguageParser.getString("UI_ALERT_REPLAY_DOWNLOAD_SUCCESS"), new ButtonType[0]).showAndWait();
            }
        }
        catch (IOException ex) {
            new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_REPLAY_DOWNLOAD_FAIL") + "\n" + ex.getMessage(), new ButtonType[0]).showAndWait();
        }
    }

    public static StackPane createReplayEntryGradientBackground(boolean isWin) {
        StackPane containerBackground = new StackPane();
        containerBackground.setMaxWidth(100.0);
        containerBackground.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)new LinearGradient(isWin ? 0.0 : 1.0, 0.0, isWin ? 1.0 : 0.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, isWin ? Color.rgb((int)0, (int)255, (int)0, (double)0.25) : Color.rgb((int)255, (int)0, (int)0, (double)0.25)), new Stop(1.0, Color.TRANSPARENT)}), null, null)}));
        StackPane.setAlignment((Node)containerBackground, (Pos)(isWin ? Pos.CENTER_LEFT : Pos.CENTER_RIGHT));
        StackPane.setMargin((Node)containerBackground, (Insets)new Insets(-5.0));
        return containerBackground;
    }

    private UtilReplays() {
    }
}

