/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.AnchorPane;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UITab;
import open.batoru.ui.chat.UITabChat;
import open.batoru.ui.deck.UITabDeck;
import open.batoru.ui.game.UITabGame;
import open.batoru.ui.home.UITabHome;
import open.batoru.ui.rooms.UITabRooms;
import open.batoru.ui.settings.UITabSettings;

public final class UI {
    private static final AnchorPane root = new AnchorPane();
    private static final TabPane tabNavigation = new TabPane();
    private static final List<UITab> listUITabs = new ArrayList<UITab>();
    private static UITabHome tabHome;
    private static UITabRooms tabRooms;
    private static UITabChat tabChat;
    private static UITabDeck tabDeck;
    private static UITabGame tabGame;

    public static void init() {
        tabNavigation.setTabMinWidth(80.0);
        tabNavigation.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        Object[] objectArray = new Tab[9];
        tabHome = new UITabHome();
        objectArray[0] = UI.addNewTab("UI_TAB_HOME", tabHome, true);
        tabRooms = new UITabRooms();
        objectArray[1] = UI.addNewTab("UI_TAB_ROOMS", tabRooms, false);
        tabChat = new UITabChat();
        objectArray[2] = UI.addNewTab("UI_TAB_CHAT", tabChat, false);
        tabDeck = new UITabDeck();
        objectArray[3] = UI.addNewTab("UI_TAB_DECK_EDIT", tabDeck, true);
        objectArray[4] = UI.addNewTab("UI_TAB_SETTINGS", new UITabSettings(), true);
        objectArray[5] = UI.addNewTab("UI_TAB_PROFILE", null, false);
        objectArray[6] = UI.addNewTab("UI_TAB_LEADERBOARDS", null, false);
        objectArray[7] = UI.addNewTab("UI_TAB_TOURNAMENT", null, false);
        tabGame = new UITabGame();
        objectArray[8] = UI.addNewTab("UI_TAB_GAME", tabGame, false);
        tabNavigation.getTabs().setAll(objectArray);
        UI.addToRoot((Node)tabNavigation, 0.0, 0.0, 0.0, 0.0);
    }

    private static Tab addNewTab(String tokenML, UITab uiTab, boolean enabled) {
        Tab tab = new Tab(LanguageParser.getString(tokenML));
        tab.setUserData((Object)LanguageParser.getString(tokenML));
        tab.setDisable(!enabled);
        listUITabs.add(uiTab);
        if (uiTab != null) {
            tab.setContent(uiTab.getTabRoot());
            if (uiTab instanceof Selectable) {
                Selectable selectable = (Selectable)((Object)uiTab);
                tab.selectedProperty().addListener((ov, oldValue, newValue) -> {
                    if (newValue.booleanValue()) {
                        selectable.onSelected();
                    } else {
                        selectable.onDeselected();
                    }
                });
            }
        }
        return tab;
    }

    public static void selectTab(UITab uiTab) {
        int idTab = listUITabs.indexOf(uiTab);
        if (idTab == -1) {
            return;
        }
        if (((Tab)tabNavigation.getTabs().get(idTab)).isDisabled()) {
            ((Tab)tabNavigation.getTabs().get(idTab)).setDisable(false);
        }
        tabNavigation.getSelectionModel().select(idTab);
    }

    public static void setTabEnabled(UITab uiTab, boolean isEnabled) {
        int idTab = listUITabs.indexOf(uiTab);
        if (idTab == -1) {
            return;
        }
        ((Tab)tabNavigation.getTabs().get(idTab)).setDisable(!isEnabled);
    }

    public static boolean isTabEnabled(UITab uiTab) {
        int idTab = listUITabs.indexOf(uiTab);
        if (idTab == -1) {
            return false;
        }
        return !((Tab)tabNavigation.getTabs().get(idTab)).isDisabled();
    }

    public static void setTabInfo(UITab uiTab, String info) {
        int idTab = listUITabs.indexOf(uiTab);
        if (idTab == -1) {
            return;
        }
        ((Tab)tabNavigation.getTabs().get(idTab)).setText(String.valueOf(((Tab)tabNavigation.getTabs().get(idTab)).getUserData()) + info);
    }

    public static String getTabInfo(UITab uiTab) {
        int idTab = listUITabs.indexOf(uiTab);
        return idTab != -1 ? ((Tab)tabNavigation.getTabs().get(idTab)).getText().substring(((Tab)tabNavigation.getTabs().get(idTab)).getUserData().toString().length()) : null;
    }

    public static UITab getCurrentTab() {
        return listUITabs.get(tabNavigation.getSelectionModel().getSelectedIndex());
    }

    public static UITabHome getTabHome() {
        return tabHome;
    }

    public static UITabRooms getTabRooms() {
        return tabRooms;
    }

    public static UITabChat getTabChat() {
        return tabChat;
    }

    public static UITabDeck getTabDeck() {
        return tabDeck;
    }

    public static UITabGame getTabGame() {
        return tabGame;
    }

    public static AnchorPane getRoot() {
        return root;
    }

    public static void addToRoot(Node node, double anchorTop, double anchorRight, double anchorBottom, double anchorLeft) {
        root.getChildren().add((Object)node);
        AnchorPane.setTopAnchor((Node)node, (Double)anchorTop);
        AnchorPane.setRightAnchor((Node)node, (Double)anchorRight);
        AnchorPane.setBottomAnchor((Node)node, (Double)anchorBottom);
        AnchorPane.setLeftAnchor((Node)node, (Double)anchorLeft);
    }

    private UI() {
    }

    public static interface Selectable {
        public void onSelected();

        public void onDeselected();
    }
}

