/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui;

import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import open.batoru.networking.UsernameData;
import open.batoru.parsers.BadgesParser;
import open.batoru.parsers.LanguageParser;

public class UsernameDisplay
extends Group {
    private final Orientation orientation;
    private final Text text;
    private Pane box;
    private HBox boxBadges;

    public UsernameDisplay(String username, Orientation orientation) {
        this.orientation = orientation;
        this.text = new Text(username);
        this.text.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
        Integer[] badgeIds = UsernameData.getBadgeIds(username);
        if (badgeIds != null && badgeIds.length > 0) {
            BadgesParser.PlayerBadge primaryBadge = BadgesParser.getBadge(badgeIds[0]);
            if (primaryBadge == null) {
                this.getChildren().add((Object)this.text);
                return;
            }
            if (!primaryBadge.hexColor().equals("#000")) {
                this.text.setStyle("-fx-fill: " + primaryBadge.hexColor());
            }
            if (orientation == Orientation.HORIZONTAL) {
                HBox container = new HBox(new Node[]{this.text});
                container.setSpacing(5.0);
                this.getChildren().add((Object)container);
                this.box = container;
                Integer[] integerArray = badgeIds;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int badgeId = integerArray[i];
                    BadgesParser.PlayerBadge badge = BadgesParser.getBadge(badgeId);
                    if (badge == null) continue;
                    container.getChildren().add((Object)this.newBadgeIcon(badge));
                }
            } else {
                VBox container = new VBox(new Node[]{this.text});
                container.setSpacing(5.0);
                this.getChildren().add((Object)container);
                this.box = container;
                if (badgeIds.length == 1) {
                    container.getChildren().add((Object)this.newBadgeIcon(primaryBadge));
                } else {
                    HBox containerBadges = new HBox();
                    containerBadges.setSpacing(5.0);
                    Integer[] integerArray = badgeIds;
                    int n = integerArray.length;
                    for (int i = 0; i < n; ++i) {
                        int badgeId = integerArray[i];
                        BadgesParser.PlayerBadge badge = BadgesParser.getBadge(badgeId);
                        if (badge == null) continue;
                        containerBadges.getChildren().add((Object)this.newBadgeIcon(badge));
                    }
                    container.getChildren().add((Object)containerBadges);
                    this.boxBadges = containerBadges;
                }
            }
        } else {
            this.getChildren().add((Object)this.text);
        }
    }

    private ImageView newBadgeIcon(BadgesParser.PlayerBadge badge) {
        ImageView imageIcon = new ImageView(badge.imageIcon());
        imageIcon.setPickOnBounds(true);
        Tooltip tooltip = new Tooltip(badge.title());
        tooltip.setShowDelay(Duration.ZERO);
        Tooltip.install((Node)imageIcon, (Tooltip)tooltip);
        return imageIcon;
    }

    public void setTextAlignment(TextAlignment textAlignment) {
        this.text.setTextAlignment(textAlignment);
    }

    public void setTextWrappingWidth(int wrappingWidth) {
        this.text.setWrappingWidth((double)wrappingWidth);
    }

    public void setBoxAlignment(Pos alignment) {
        if (this.box == null) {
            return;
        }
        if (this.orientation == Orientation.HORIZONTAL) {
            ((HBox)this.box).setAlignment(alignment);
        } else {
            ((VBox)this.box).setAlignment(alignment);
            if (this.boxBadges != null) {
                this.boxBadges.setAlignment(alignment);
            }
        }
    }

    public void setBoxStyle(String cssClass, boolean set) {
        if (this.box == null) {
            return;
        }
        if (set) {
            this.box.getStyleClass().add((Object)cssClass);
        } else {
            this.box.getStyleClass().remove((Object)cssClass);
        }
    }
}

