/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.deck;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebView;
import open.batoru.Settings;
import open.batoru.catalog.SearchFilter;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.data.CardConst;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.deck.OptionFilters;

public class AdvancedFiltersPicker
extends StackPane {
    private static Function<String, Boolean> checkerFuncIsCrossedText;
    private final GridPane grid = new GridPane();
    private final ToggleButton sourceButton;
    private int enabledFilters;
    private final CheckBox checkBoxInvert;
    private final TextField filterCost;
    private final List<AdvancedFilterOption> listFilterOptions = new ArrayList<AdvancedFilterOption>();
    private DescriptionParser descriptionParser = DescriptionParser.getThemedDescriptionParser();

    public AdvancedFiltersPicker(ToggleButton sourceButton) {
        this.sourceButton = sourceButton;
        this.getStyleClass().add((Object)"ui_deck_panel_window_advanced_filters");
        this.setMinSize(400.0, 415.0);
        this.setMaxSize(this.getMinWidth(), this.getMinHeight());
        this.setPadding(new Insets(10.0));
        this.grid.setPadding(new Insets(30.0, 0.0, 0.0, 0.0));
        this.grid.setHgap(10.0);
        this.grid.setVgap(5.0);
        if (checkerFuncIsCrossedText == null) {
            if (!Settings.INSTANCE.getGameLanguage().equals("jp")) {
                String textCross = LanguageParser.getString("CARD_TEXT_CROSS").toLowerCase();
                checkerFuncIsCrossedText = description -> description.contains(textCross);
            } else {
                Pattern patternIsolatedCross = Pattern.compile("(?<!\\p{InKatakana})" + LanguageParser.getString("CARD_TEXT_CROSS") + "(?!\\p{InKatakana})");
                checkerFuncIsCrossedText = description -> patternIsolatedCross.matcher((CharSequence)description).find();
            }
        }
        Label labelCost = new Label(LanguageParser.getString("CARD_INFO_COST"));
        this.filterCost = new TextField();
        this.filterCost.setPromptText("\u2264X");
        this.filterCost.setTextFormatter(OptionFilters.formatterNumerical());
        this.filterCost.setPrefWidth(50.0);
        HBox boxFilter = new HBox();
        boxFilter.setAlignment(Pos.BASELINE_CENTER);
        boxFilter.setSpacing(5.0);
        boxFilter.getChildren().addAll((Object[])new Node[]{labelCost, this.filterCost});
        this.filterCost.textProperty().addListener((ov, oldValue, newValue) -> UI.getTabDeck().getCardCatalog().getSearchFilter().filterCost(OptionFilters.parseNumberOptionFilter(newValue)));
        this.filterCost.disableProperty().addListener((ov, oldValue, newValue) -> UI.getTabDeck().getCardCatalog().getSearchFilter().filterCost(OptionFilters.parseNumberOptionFilter(newValue != false ? "" : this.filterCost.getText())));
        this.checkBoxInvert = new CheckBox(LanguageParser.getString("UI_DECK_FILTER_CHECKBOX_ADVANCED_INVERT"));
        this.checkBoxInvert.setOnAction(e -> {
            UI.getTabDeck().getCardCatalog().getSearchFilter().filterToggleInvertKeywords();
            this.filterCost.setPromptText(this.checkBoxInvert.isSelected() ? ">X" : "\u2264X");
            if (this.enabledFilters > 0) {
                if (this.checkBoxInvert.isSelected()) {
                    sourceButton.getStyleClass().add((Object)"ui_deck_panel_window_advanced_filters_button_enabled_invert");
                    sourceButton.getStyleClass().remove((Object)"ui_deck_panel_window_advanced_filters_button_enabled");
                } else {
                    sourceButton.getStyleClass().add((Object)"ui_deck_panel_window_advanced_filters_button_enabled");
                    sourceButton.getStyleClass().remove((Object)"ui_deck_panel_window_advanced_filters_button_enabled_invert");
                }
            }
        });
        BorderPane containerControls = new BorderPane();
        containerControls.setLeft((Node)this.checkBoxInvert);
        containerControls.setRight((Node)boxFilter);
        containerControls.setMaxHeight(this.grid.getPadding().getTop());
        StackPane.setAlignment((Node)containerControls, (Pos)Pos.TOP_CENTER);
        this.getChildren().addAll((Object[])new Node[]{this.grid, containerControls});
        this.populate();
    }

    private void populate() {
        this.addFilter("@C");
        this.addFilter("{C");
        this.addFilter("@U");
        this.addFilter("{U");
        this.addFilter("@E");
        this.addFilter("{E");
        this.addFilter("@A");
        this.addFilter("{A");
        this.addFilter("$T1", c -> c.getDescription().contains("$T2"));
        this.addFilter("$G1");
        this.addFilter("-M", c -> (c.getUseTiming() & 1) != 0);
        this.addFilter("-A", c -> (c.getUseTiming() & 2) != 0);
        this.addFilter("-S", c -> (c.getUseTiming() & 4) != 0);
        this.addFilter("&E");
        this.addFilter("=R", "/ &R", c -> c.getDescription().contains("&R"));
        this.addFilter("=H");
        this.addFilter("=X", "/ #H", c -> c.getDescription().contains("#H") || checkerFuncIsCrossedText.apply(c.getDescription()) != false);
        this.addFilter("=I", "/ " + LanguageParser.getString("CARD_TEXT_DRIVE"), c -> c.getDescription().contains(LanguageParser.getString("CARD_TEXT_DRIVE").toLowerCase()) || c.getDescription().contains("\\C") || c.getDescription().contains("\\U"));
        this.addFilter("=T");
        this.addFilter(" #C", c -> c.getCoins() > 0 || c.getCost().getDataArray().stream().anyMatch(cost -> cost.contains("C")));
        this.addFilter("=E");
        this.addFilter(" #D");
        this.addFilter(" #S", c -> (c.getCardFlags() & 0x20) != 0);
        this.addFilter("%X", c -> c.getCost().getDataArray().stream().anyMatch(cost -> cost.contains(String.valueOf(CardConst.CardColor.COLORLESS.getShortLabel()))));
        this.addFilter("%W", c -> c.getCost().getDataArray().stream().anyMatch(cost -> cost.contains(String.valueOf(CardConst.CardColor.WHITE.getShortLabel()))));
        this.addFilter("%R", c -> c.getCost().getDataArray().stream().anyMatch(cost -> cost.contains(String.valueOf(CardConst.CardColor.RED.getShortLabel()))));
        this.addFilter("%B", c -> c.getCost().getDataArray().stream().anyMatch(cost -> cost.contains(String.valueOf(CardConst.CardColor.BLUE.getShortLabel()))));
        this.addFilter("%G", c -> c.getCost().getDataArray().stream().anyMatch(cost -> cost.contains(String.valueOf(CardConst.CardColor.GREEN.getShortLabel()))));
        this.addFilter("%K", c -> c.getCost().getDataArray().stream().anyMatch(cost -> cost.contains(String.valueOf(CardConst.CardColor.BLACK.getShortLabel()))));
    }

    public void syncWithTheme() {
        DescriptionParser currentThemedParser = DescriptionParser.getThemedDescriptionParser();
        if (this.descriptionParser == currentThemedParser) {
            return;
        }
        this.descriptionParser = currentThemedParser;
        for (AdvancedFilterOption filterOption : this.listFilterOptions) {
            filterOption.reloadContent();
        }
    }

    private void addFilter(String keywordText) {
        this.addFilter(keywordText, null);
    }

    private void addFilter(String keywordText, SearchFilter.AlternativeCardFilter alternativeCardFilter) {
        this.addFilter(keywordText, null, alternativeCardFilter);
    }

    private void addFilter(String keywordText, String keywordTextExtension, SearchFilter.AlternativeCardFilter alternativeCardFilter) {
        AdvancedFilterOption filterOption = new AdvancedFilterOption(keywordText, keywordTextExtension, alternativeCardFilter);
        this.grid.add((Node)filterOption, this.listFilterOptions.size() % 2, this.listFilterOptions.size() / 2);
        this.listFilterOptions.add(filterOption);
    }

    public void toggleFiltersByCardType(CardConst.CardType filterType) {
        this.filterCost.setDisable(filterType != null && CardConst.CardType.isSIGNI(filterType));
    }

    public void clear() {
        this.checkBoxInvert.setSelected(false);
        this.filterCost.setPromptText("\u2264X");
        this.filterCost.clear();
        this.listFilterOptions.forEach(filterOption -> filterOption.getCheckBox().setSelected(false));
        this.enabledFilters = 0;
        this.sourceButton.setText(LanguageParser.getString("UI_DECK_FILTER_BUTTON_ADVANCED"));
        this.sourceButton.getStyleClass().removeAll((Object[])new String[]{"ui_deck_panel_window_advanced_filters_button_enabled", "ui_deck_panel_window_advanced_filters_button_enabled_invert"});
        UI.getTabDeck().getCardCatalog().getSearchFilter().clearKeywordFilter();
    }

    public class AdvancedFilterOption
    extends HBox {
        private final CheckBox checkBox;
        private final WebView webView;
        private final StringBuilder description;

        public AdvancedFilterOption(String keywordText, String keywordTextExtension, SearchFilter.AlternativeCardFilter alternativeCardFilter) {
            this.setAlignment(Pos.CENTER);
            this.setSpacing(5.0);
            this.setMinSize(185.0, 20.0);
            this.setMaxSize(this.getMinWidth(), this.getMinHeight());
            this.checkBox = new CheckBox();
            this.checkBox.setOnAction(e -> {
                UI.getTabDeck().getCardCatalog().getSearchFilter().filterToggleKeyword(new SearchFilter.AdvancedKeywordFilter(keywordText, alternativeCardFilter));
                AdvancedFiltersPicker.this.enabledFilters = AdvancedFiltersPicker.this.enabledFilters + (this.checkBox.isSelected() ? 1 : -1);
                if (AdvancedFiltersPicker.this.enabledFilters > 0) {
                    AdvancedFiltersPicker.this.sourceButton.setText(LanguageParser.getString("UI_DECK_FILTER_BUTTON_ADVANCED") + " [" + AdvancedFiltersPicker.this.enabledFilters + "]");
                    if (this.checkBox.isSelected() && AdvancedFiltersPicker.this.enabledFilters == 1) {
                        AdvancedFiltersPicker.this.sourceButton.getStyleClass().add((Object)("ui_deck_panel_window_advanced_filters_button_enabled" + (!AdvancedFiltersPicker.this.checkBoxInvert.isSelected() ? "" : "_invert")));
                    }
                } else {
                    AdvancedFiltersPicker.this.sourceButton.setText(LanguageParser.getString("UI_DECK_FILTER_BUTTON_ADVANCED"));
                    AdvancedFiltersPicker.this.sourceButton.getStyleClass().removeAll((Object[])new String[]{"ui_deck_panel_window_advanced_filters_button_enabled", "ui_deck_panel_window_advanced_filters_button_enabled_invert"});
                }
            });
            this.webView = new WebView();
            this.webView.setContextMenuEnabled(false);
            this.webView.getEngine().setJavaScriptEnabled(false);
            this.description = new StringBuilder(keywordText);
            if (keywordTextExtension != null) {
                this.description.append(keywordTextExtension);
            }
            this.reloadContent();
            this.webView.setMaxSize(160.0, 20.0);
            this.getChildren().addAll((Object[])new Node[]{this.checkBox, this.webView});
        }

        public CheckBox getCheckBox() {
            return this.checkBox;
        }

        public final void reloadContent() {
            this.webView.getEngine().loadContent("<style>body {overflow: hidden;}</style>" + AdvancedFiltersPicker.this.descriptionParser.parseDescription(this.description.toString()));
        }
    }
}

