/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.deck;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.ImageCache;
import open.batoru.Settings;
import open.batoru.core.Deck;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.CardLoader;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.UtilDispose;
import open.batoru.ui.deck.CardImageSetPicker;
import open.batoru.ui.deck.RestrictIconsContainer;

public class DeckBuilder {
    private boolean isDisabled;
    private final Map<StackPane, RestrictIconsContainer> cardContainerRestrictIcons = new HashMap<StackPane, RestrictIconsContainer>();
    private final Button buttonImageSet = new Button("\ud83c\udfa8");
    private final Button buttonDuplicate;

    public DeckBuilder() {
        this.buttonImageSet.setFont(Font.loadFont((String)"file:fonts/Symbola-12.ttf", (double)18.0));
        this.buttonImageSet.setPadding(Insets.EMPTY);
        this.buttonImageSet.setPrefSize(30.0, 30.0);
        this.buttonImageSet.getStyleClass().add((Object)"ui_deck_panel_button_art");
        StackPane.setAlignment((Node)this.buttonImageSet, (Pos)Pos.TOP_LEFT);
        StackPane.setMargin((Node)this.buttonImageSet, (Insets)new Insets(5.0));
        this.buttonDuplicate = new Button("\u2795");
        this.buttonDuplicate.setFont(Font.loadFont((String)"file:fonts/Symbola-12.ttf", (double)18.0));
        this.buttonDuplicate.setPadding(Insets.EMPTY);
        this.buttonDuplicate.setPrefSize(30.0, 30.0);
        this.buttonDuplicate.getStyleClass().add((Object)"ui_deck_panel_button_art");
        StackPane.setAlignment((Node)this.buttonDuplicate, (Pos)Pos.TOP_RIGHT);
        StackPane.setMargin((Node)this.buttonDuplicate, (Insets)new Insets(5.0));
    }

    public void initCards() {
        Deck currentDeck = Settings.INSTANCE.getCurrentDeck();
        UI.getTabDeck().updateDeckStatus();
        List<String> deckList = currentDeck.getDeckList();
        for (String imageSet : deckList) {
            this.addNewCardToBuilder(imageSet);
        }
    }

    public void reloadDeck() {
        this.clearAllCards();
        this.initCards();
    }

    public void clearAllCards() {
        if (this.isDisabled) {
            return;
        }
        UI.getTabDeck().getCardCountBar().clearAll();
        UI.getTabDeck().getColorsCountBar().clearAll();
        this.cardContainerRestrictIcons.clear();
        UI.getTabDeck().getDeckContainerNode(Deck.DeckType.MAIN).getChildren().clear();
        UI.getTabDeck().getDeckContainerNode(Deck.DeckType.LRIG).getChildren().clear();
    }

    public void addNewCardToDeck(String imageSet) {
        if (this.isDisabled) {
            return;
        }
        int arrayId = Settings.INSTANCE.getCurrentDeck().addCard(imageSet);
        if (arrayId != -1) {
            this.addNewCardToBuilder(imageSet, arrayId);
        }
        UI.getTabDeck().updateDeckStatus();
    }

    public void removeCard(StackPane cardContainer, String imageSet) {
        if (this.isDisabled || cardContainer == null || imageSet == null) {
            return;
        }
        Settings.INSTANCE.getCurrentDeck().removeCard(imageSet);
        ((Pane)cardContainer.getParent()).getChildren().remove((Object)cardContainer);
        Card cardObject = CardLoader.getCardByImageSet(imageSet);
        UI.getTabDeck().getCardCountBar().removeCard(cardObject);
        if (Deck.isMainDeckCard(cardObject)) {
            UI.getTabDeck().getColorsCountBar().removeCard(cardObject);
        }
        UI.getTabDeck().updateDeckStatus();
        this.cardContainerRestrictIcons.remove(cardContainer);
        this.cardContainerRestrictIcons.values().forEach(RestrictIconsContainer::update);
    }

    private void addNewCardToBuilder(String imageSet) {
        this.addNewCardToBuilder(imageSet, -1);
    }

    private void addNewCardToBuilder(String imageSet, int arrayId) {
        ImageView cardImage2;
        Card cardObject = CardLoader.getCardByImageSet(imageSet);
        UI.getTabDeck().getCardCountBar().addCard(cardObject);
        if (Deck.isMainDeckCard(cardObject)) {
            UI.getTabDeck().getColorsCountBar().addCard(cardObject);
        }
        StackPane cardContainer = new StackPane();
        cardContainer.getStyleClass().add((Object)"ui_deck_panel");
        cardContainer.setPadding(new Insets(5.0));
        ImageView cardImage = new ImageView(ImageCache.INSTANCE.getCardImage(imageSet));
        cardImage.setFitWidth(100.0);
        cardImage.setFitHeight(140.0);
        Polygon clipTriangle = null;
        Line lineClipSeparator = null;
        cardImage.setOpacity(!Settings.INSTANCE.getGameLanguage().equals("jp") && cardObject.getTranslatedName().isEmpty() ? 0.66 : 1.0);
        StackPane cardImageContainer = new StackPane();
        cardImageContainer.setMinSize(100.0, 140.0);
        cardImageContainer.setMaxSize(100.0, 140.0);
        cardImageContainer.getChildren().add((Object)cardImage);
        cardContainer.getChildren().add((Object)cardImageContainer);
        Rectangle clip = new Rectangle(100.0, 140.0);
        clip.setArcWidth(11.0);
        clip.setArcHeight(11.0);
        cardImageContainer.setClip((Node)clip);
        if (cardObject.getDoubleFacedCardPairObject() != null) {
            arrayId = -1;
            cardImage2 = new ImageView(ImageCache.INSTANCE.getCardImage(CardDataImageSet.getDoubleFacedPairImageSet(cardObject, imageSet)));
            cardImage2.fitWidthProperty().bind((ObservableValue)cardImage.fitWidthProperty());
            cardImage2.fitHeightProperty().bind((ObservableValue)cardImage.fitHeightProperty());
            clipTriangle = new Polygon(new double[]{100.0, 0.0, 100.0, 140.0, 0.0, 140.0});
            cardImage2.setClip((Node)clipTriangle);
            lineClipSeparator = new Line(100.0, 0.0, 0.0, 140.0);
            lineClipSeparator.setStroke((Paint)Color.RED);
            AnchorPane anchorSideText = new AnchorPane();
            anchorSideText.setMouseTransparent(true);
            Text textA = new Text(cardObject.getCardFace() == CardConst.CardFace.FRONT ? "A" : "B");
            textA.getStyleClass().add((Object)"ui_deck_panel_text_red");
            textA.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)24.0));
            Text textB = new Text(cardObject.getCardFace() == CardConst.CardFace.FRONT ? "B" : "A");
            textB.getStyleClass().add((Object)"ui_deck_panel_text_red");
            textB.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)24.0));
            anchorSideText.getChildren().addAll((Object[])new Node[]{textA, textB});
            AnchorPane.setTopAnchor((Node)textA, (Double)3.0);
            AnchorPane.setLeftAnchor((Node)textA, (Double)6.0);
            AnchorPane.setBottomAnchor((Node)textB, (Double)3.0);
            AnchorPane.setRightAnchor((Node)textB, (Double)6.0);
            cardImageContainer.getChildren().addAll((Object[])new Node[]{cardImage2, lineClipSeparator, anchorSideText});
        } else {
            cardImage2 = null;
        }
        if (cardObject.canGuard()) {
            ImageView guardIcon = new ImageView(ImageCache.INSTANCE.getImageIcon("guard"));
            guardIcon.setMouseTransparent(true);
            cardContainer.getChildren().add((Object)guardIcon);
        }
        if (cardObject.hasLifeBurst()) {
            ImageView lifeBurstIcon = new ImageView(ImageCache.INSTANCE.getImageIcon("lifeburst"));
            lifeBurstIcon.setMouseTransparent(true);
            cardContainer.getChildren().add((Object)lifeBurstIcon);
        }
        RestrictIconsContainer restrictIconsContainer = new RestrictIconsContainer(imageSet);
        restrictIconsContainer.update();
        StackPane.setAlignment((Node)restrictIconsContainer, (Pos)Pos.TOP_RIGHT);
        cardContainer.getChildren().add((Object)restrictIconsContainer);
        this.cardContainerRestrictIcons.put(cardContainer, restrictIconsContainer);
        this.cardContainerRestrictIcons.values().forEach(iconsContainer -> {
            if (iconsContainer != restrictIconsContainer) {
                iconsContainer.update();
            }
        });
        cardImage.setOnMouseEntered(e -> {
            cardContainer.setCursor(Cursor.HAND);
            cardContainer.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"highlight"), true);
            if (!e.isAltDown()) {
                UI.getTabDeck().getCardPreview().update(imageSet);
            }
        });
        if (cardImage2 != null) {
            cardImage2.setOnMouseEntered(e -> {
                cardContainer.setCursor(Cursor.HAND);
                cardContainer.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"highlight"), true);
                if (!e.isAltDown()) {
                    UI.getTabDeck().getCardPreview().update(CardDataImageSet.getDoubleFacedPairImageSet(cardObject, imageSet));
                }
            });
        }
        cardImageContainer.setOnMouseEntered(e -> {
            if (cardObject.getImageSets().getImageSetsNum() > 1) {
                cardImageContainer.getChildren().add((Object)this.buttonImageSet);
                this.buttonImageSet.setOnAction(e2 -> this.changeCardImageSet(cardContainer, cardObject, imageSet));
            }
            if (Deck.isMainDeckCard(cardObject)) {
                cardImageContainer.getChildren().add((Object)this.buttonDuplicate);
                this.buttonDuplicate.setOnAction(e2 -> this.addNewCardToDeck(imageSet));
            }
        });
        cardImageContainer.setOnMouseExited(e -> cardImageContainer.getChildren().removeAll((Object[])new Node[]{this.buttonImageSet, this.buttonDuplicate}));
        cardContainer.setOnMouseExited(e -> {
            cardContainer.setCursor(Cursor.DEFAULT);
            cardContainer.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"highlight"), false);
        });
        cardContainer.setOnMouseClicked(e -> {
            if (this.isDisabled) {
                return;
            }
            switch (e.getButton()) {
                case PRIMARY: {
                    if (!e.isControlDown()) {
                        this.removeCard(cardContainer, imageSet);
                        break;
                    }
                    this.addNewCardToDeck(imageSet);
                    break;
                }
                case SECONDARY: {
                    if (cardObject.getImageSets().getImageSetsNum() <= 1) break;
                    this.changeCardImageSet(cardContainer, cardObject, imageSet);
                }
            }
        });
        if (cardImage2 != null) {
            clipTriangle.getPoints().set(0, (Object)cardImage.getFitWidth());
            clipTriangle.getPoints().set(2, (Object)cardImage.getFitWidth());
            clipTriangle.getPoints().set(3, (Object)cardImage.getFitHeight());
            clipTriangle.getPoints().set(5, (Object)cardImage.getFitHeight());
            lineClipSeparator.setStartX(cardImage.getFitWidth());
            lineClipSeparator.setEndY(cardImage.getFitHeight());
        }
        UtilDispose.PERM.setOnDisposed((Node)cardContainer, () -> {
            cardImage.setImage(null);
            cardImage.setOnMouseEntered(null);
            if (cardImage2 != null) {
                cardImage2.setImage(null);
                cardImage2.setOnMouseEntered(null);
            }
            cardImageContainer.setOnMouseEntered(null);
            cardImageContainer.setOnMouseExited(null);
            cardContainer.setOnMouseExited(null);
            cardContainer.setOnMouseClicked(null);
        });
        FlowPane deckContainerNode = UI.getTabDeck().getDeckContainerNode(Deck.isMainDeckCard(cardObject) ? Deck.DeckType.MAIN : Deck.DeckType.LRIG);
        deckContainerNode.getChildren().add(arrayId != -1 && arrayId < deckContainerNode.getChildren().size() ? arrayId : deckContainerNode.getChildren().size(), (Object)cardContainer);
    }

    private void changeCardImageSet(StackPane cardContainer, Card cardObject, String imageSet) {
        CardImageSetPicker picker = new CardImageSetPicker(cardObject.getImageSets().getDataArray(), imageSetPicked -> {
            UI.getTabDeck().setCardImageSetPicker(null);
            if (imageSet.equals(imageSetPicked)) {
                return;
            }
            if (imageSetPicked != null) {
                this.removeCard(cardContainer, imageSet);
                this.addNewCardToDeck(imageSetPicked);
            }
        });
        UI.getTabDeck().setCardImageSetPicker(picker);
    }

    public void setDeckBuildingEnabled(boolean isEnabled) {
        this.isDisabled = !isEnabled;
        UI.getTabDeck().getButtonLoad().setDisable(this.isDisabled);
        UI.getTabDeck().getButtonSave().setDisable(this.isDisabled);
        UI.getTabDeck().getButtonClear().setDisable(this.isDisabled);
    }
}

