/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.deck;

import java.util.Arrays;
import java.util.function.UnaryOperator;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TextFormatter;
import open.batoru.data.CardConst;
import open.batoru.parsers.CardSetsParser;
import open.batoru.parsers.LanguageParser;
import open.batoru.parsers.RestrictedCardsParser;

public class OptionFilters {
    public static TextFormatter<UnaryOperator<TextFormatter.Change>> formatterNumerical() {
        return new TextFormatter(change -> change.getText().matches("[0-9]*") ? change : null);
    }

    public static ObservableList<String> getTypeList() {
        ObservableList options = FXCollections.observableArrayList();
        options.add((Object)LanguageParser.getString("CATALOG_FILTER_ANY"));
        for (CardConst.CardType cardType : CardConst.CardType.values()) {
            if (cardType == CardConst.CardType.TOKEN) continue;
            options.add((Object)cardType.getLabel());
        }
        return options;
    }

    public static ObservableList<String> getColorList() {
        ObservableList options = FXCollections.observableArrayList();
        options.add((Object)LanguageParser.getString("CATALOG_FILTER_ANY"));
        for (CardConst.CardColor cardColor : CardConst.CardColor.values()) {
            options.add((Object)cardColor.getLabel());
        }
        return options;
    }

    public static ObservableList<String> getLRIGTypeList() {
        ObservableList options = FXCollections.observableArrayList();
        options.add((Object)LanguageParser.getString("CATALOG_FILTER_ANY"));
        for (CardConst.CardLRIGType cardLRIGType : CardConst.CardLRIGType.values()) {
            options.add((Object)cardLRIGType.getLabel());
        }
        FXCollections.sort((ObservableList)options, (s1, s2) -> {
            if (s1.equals(LanguageParser.getString("CATALOG_FILTER_ANY")) || s1.equals(LanguageParser.getString("CARD_LRIG_TYPE_NO_LIMIT"))) {
                return -1;
            }
            if (s1.equals(LanguageParser.getString("CARD_LRIG_TYPE_WHITE_ROOM"))) {
                return 1;
            }
            if (s2.equals(LanguageParser.getString("CARD_LRIG_TYPE_WHITE_ROOM"))) {
                return -1;
            }
            return LanguageParser.getCollator().compare((String)s1, (String)s2);
        });
        return options;
    }

    public static ObservableList<String> getSIGNIClassList() {
        ObservableList options = FXCollections.observableArrayList();
        options.add((Object)LanguageParser.getString("CATALOG_FILTER_ANY"));
        for (CardConst.CardSIGNIClass cardSIGNIClass : CardConst.CardSIGNIClass.values()) {
            options.add((Object)cardSIGNIClass.getLabel());
        }
        FXCollections.sort((ObservableList)options, (s1, s2) -> {
            if (s1.equals(LanguageParser.getString("CATALOG_FILTER_ANY"))) {
                return -1;
            }
            return LanguageParser.getCollator().compare((String)s1, (String)s2);
        });
        return options;
    }

    public static ObservableList<String> getSetsList() {
        ObservableList options = FXCollections.observableArrayList();
        options.add((Object)LanguageParser.getString("CATALOG_FILTER_ANY"));
        options.addAll(CardSetsParser.getSetsAsOptionArray());
        return options;
    }

    public static ObservableList<String> getRestrictList() {
        ObservableList options = FXCollections.observableArrayList();
        options.add((Object)LanguageParser.getString("CATALOG_FILTER_ANY"));
        options.add((Object)LanguageParser.getString("CATALOG_FILTER_RESTRICT_UP_TO_TWO"));
        options.add((Object)LanguageParser.getString("CATALOG_FILTER_RESTRICT_SIMULTANEOUS"));
        options.add((Object)LanguageParser.getString("CATALOG_FILTER_RESTRICT_DISABLED"));
        options.add((Object)LanguageParser.getString("CATALOG_FILTER_RESTRICT_UNRELEASED"));
        options.add((Object)LanguageParser.getString("CATALOG_FILTER_RESTRICT_TOKEN"));
        return options;
    }

    public static ObservableList<String> getFormatList() {
        ObservableList options = FXCollections.observableArrayList();
        options.add((Object)LanguageParser.getString("CATALOG_FILTER_ANY"));
        for (CardConst.PlayFormat playFormat : CardConst.PlayFormat.values()) {
            options.add((Object)playFormat.getLabel());
        }
        return options;
    }

    public static int parseNumberOptionFilter(String value) {
        return value.isEmpty() ? -1 : Integer.parseInt(value);
    }

    public static String parseSetOptionFilter(String value) {
        if (value.charAt(0) != LanguageParser.getString("CATALOG_FILTER_ANY").charAt(0)) {
            return CardSetsParser.getSetPrefix(value);
        }
        return "";
    }

    public static RestrictedCardsParser.RestrictType parseRestrictOptionFilter(String value) {
        if (value.charAt(0) != LanguageParser.getString("CATALOG_FILTER_ANY").charAt(0)) {
            if (value.equals(LanguageParser.getString("CATALOG_FILTER_RESTRICT_SIMULTANEOUS")) || value.equals(LanguageParser.getString("CATALOG_FILTER_RESTRICT_UNRELEASED"))) {
                return RestrictedCardsParser.RestrictType.NONE;
            }
            int arrayId = 0;
            for (int i = 1; i < RestrictedCardsParser.RestrictType.values().length; ++i) {
                if (!value.equals(RestrictedCardsParser.RestrictType.values()[i].getLabel())) continue;
                arrayId = i;
            }
            return RestrictedCardsParser.RestrictType.values()[arrayId];
        }
        return RestrictedCardsParser.RestrictType.NONE;
    }

    public static RestrictedCardsParser.SpecialRestrictType parseSpecialRestrictOptionFilter(String value) {
        if (value.charAt(0) != LanguageParser.getString("CATALOG_FILTER_ANY").charAt(0)) {
            if (value.equals(LanguageParser.getString("CATALOG_FILTER_RESTRICT_SIMULTANEOUS"))) {
                return RestrictedCardsParser.SpecialRestrictType.SIMULTANEOUS;
            }
            if (value.equals(LanguageParser.getString("CATALOG_FILTER_RESTRICT_UNRELEASED"))) {
                return RestrictedCardsParser.SpecialRestrictType.UNRELEASED;
            }
        }
        return null;
    }

    public static CardConst.PlayFormat parseFormatOptionFilter(String value) {
        return Arrays.stream(CardConst.PlayFormat.values()).filter(playFormat -> playFormat.getLabel().equals(value)).findFirst().orElse(null);
    }
}

